/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/pgp/register', [
    'io.ox/core/extensions',
    'io.ox/core/extPatterns/links',
    'oxguard/core/og_http',
    'oxguard/pgp/checker',
    'io.ox/core/api/account',
    'pgp_mail/util',
    'settings!oxguard',
    'gettext!oxguard'
], function (ext, links, http, checker, account, util, settings, gt) {
    'use strict';

    var popupBlockCount = 0;

    // Detail View Extensions
    ext.point('io.ox/mail/detail').extend({
        index: 2,
        id: 'ogPGPCheck',
        draw: function (baton) {
            checker.checkPGP.call(this, baton);
            baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                checker.checkPGP(baton);
            });
        }
    });

    ext.point('io.ox/mail/mobile/detail/header').extend({
        index: 230,
        id: 'ogPGPCheckMobile',
        draw: function (baton) {
            checker.checkPGP.call(this, baton);
            baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                checker.checkPGP(baton);
                if (baton.view.$el === null) return;
                if (!_.device('ios')) {
                    window.setTimeout(function () {
                        baton.view.$el.find('#oxgrpass').focus();
                    }, 50);
                }

            });
        }
    });

    // Add lock to header
    ext.point('io.ox/mail/detail/header').extend({
        index: 230,
        id: 'pgpMailLock',
        draw: function (baton) {
            if (baton.data.PGPresults !== undefined) {
                // Add lock symbol to header
                var lockdiv = $('<div style="float:left; padding-right:5px;" id="lockdiv" class="oxguard_lock" ></div>');
                var lockstack = '<span class="icon-stack" title="' + gt('This Email was sent using PGP encryption. It has been decrypted with your private key') + '"><i class="icon-lock icon-large icon-stack-base fa fa-lock -fa-large oxguard_lock" />' +
                    '<i class ="icon-star-half-empty" style="color:black; margin-top:5px;"/></span>';
                lockdiv.append($(lockstack));
                if (baton.data.PGPresults.verified === true) {
                    lockdiv.append('<i class="icon-edit" title="' + gt('This Email was signed by the sender and verified') + '"/>');
                }
                $(this).prepend(lockdiv);
            }
        }
    });

    // Check if attachment filename ends with .asc
    function isASC (e) {
        try {
            if (e.context instanceof Array) {
                for (var i = 0; i < e.context.length; i++) {
                    if (e.context[i].filename.indexOf('.asc') > 0) {
                        // Do not return positive for signatures.  Handled differently
                        if (e.context[i].content_type.indexOf('sig') > 0) return false;
                        return true;
                    }
                }
            }
            var filename = e.context.filename;
            if (filename === undefined) return false;
            if (e.context.content_type.indexOf('sig') > 0) return false;
            return (filename.indexOf('.asc') > 0);
        } catch (d) {
            console.log(d);
            return false;
        }
    }

    function isInline(e) {
        try {
            if (e.context instanceof Array) {
                for (var i = 0; i < e.context.length; i++) {
                    if (e.context[i].pgpFormat === 'pgpinline') return (true);
                    if (e.context[i].pgpFormat === 'pgpmime') return (false);
                    if (e.context[i].filename.indexOf('.pgp') > 0) return true;
                }
            } else {
                if (e.context.pgpFormat === 'pgpinline') return (true);
                if (e.context.pgpFormat === 'pgpmime') return (false);
            }
            var filename = e.context.filename;
            if (filename === undefined) return false;
            return (filename.indexOf('.pgp') > 0);
        } catch (d) {
            console.log(d);
            return false;
        }
    }

    // Email Actions

    // Make excisting mail extensions Guard aware
    addGuardAwareExtension ('io.ox/mail/actions/download-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/open-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/preview-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/slideshow-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/save-attachment');
    addGuardAwareExtension ('io.ox/mail/actions/vcard');
    addGuardAwareExtension ('io.ox/mail/actions/ical');
    addGuardAwareExtension ('io.ox/mail/office/text/edit-as-new');
    addGuardAwareExtension ('io.ox/mail/office/spreadsheet/edit-as-new');
    addGuardAwareExtension ('io.ox/mail/actions/view-attachment');

    // Adds check for Guard files to base and office UI extensions
    function addGuardAwareExtension (e) {
        new links.Action(e, {
            id: 'stop',
            index: 1,
            requires: function (e) {
                if (isPGPAttach(e)) {
                    e.stopPropagation();
                }
                return false;
            }
        });
    }

    // Action to open OxGuard attachment
    new links.Action('io.ox/mail/actions/view-OGPGPattachment', {
        id: 'viewOGPGP',
        requires: function (e) {
            return !isInline(e) && isPGPAttach(e);
        },
        multiple: function (list) {
            _(list).each(function (data) {
                var params = '&emailid=' + data.parent.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.parent.folder_id +
                '&attname=' + encodeURIComponent(data.filename);
                data.guardUrl = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
                data.source = 'guard';
                data.origData = data;
                data.folder_id = data.parent.folder_id;
                delete(data.mail);
            });
            ox.load(['io.ox/mail/actions/viewer']).done(function (action) {
                action({ files: list });
            });
        }
    });

    // Open viewer for PGP Inline
    new links.Action('io.ox/mail/actions/view-OGPGPinline', {
        id: 'openOGPGPinline',
        requires: function (e) {
            return isInline(e);
        },
        multiple: function (list) {
            _(list).each(function (data) {
                var filename = data.filename.replace('.pgp', '');
                var params = '&emailid=' + data.parent.id +
                    '&attach=' + data.id +
                    '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    '&epassword=' + encodeURIComponent(data.epass) +
                    '&folder=' + data.parent.folder_id +
                    '&attname=' + encodeURIComponent(filename);
                data.guardUrl = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getinlineattach' + params;
                data.source = 'guard';
                data.filename = data.filename.replace('.pgp', '');
                data.origData = data;
                delete(data.mail);
            });
            ox.load(['io.ox/mail/actions/viewer']).done(function (action) {
                action({ files: list });
            });
        }
    });

    // Action to open OxGuard attachment
    new links.Action('io.ox/mail/actions/open-OGPGPattachment', {
        id: 'openOGPGP',
        requires: function (e) {
            return !isInline(e) && isPGPAttach(e);
        },
        multiple: function (list) {
            _(list).each(function (data) {
                var params = '&emailid=' + data.parent.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.parent.folder_id +
                '&attname=' + encodeURIComponent(data.filename);
                var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
                var popup = window.open(link);
                if (popup === null || popup === undefined) {
                    // If popup blocked, give one try to see if user notices, otherwise alert message regarding blocking
                    if (popupBlockCount === 1) {
                        require (['io.ox/core/notifications'], function (notifications) {
                            //#. Error message when trying to open a file with popup blocker on browser blocking
                            notifications.yell('error', gt('Your pop-up blocker may have prevented a Guard window that provides application functionality.'));
                        });
                        //  window.location.href = link;
                    }
                    popupBlockCount++;
                }
            });
        }
    });

    // Download encrypted attachment
    new links.Action('io.ox/mail/actions/download-OGPGPattachment', {
        id: 'DownloadOGPGP',
        requires: function (e) {
            return !isInline(e) && isPGPAttach(e);
        },
        multiple: function (list) {
            _(list).each(function (data) {
                downloadMime(data);
            });
        }
    });

    function downloadMime(data) {
        var params = '&emailid=' + data.parent.id +
        '&attach=' + data.id +
        '&session=' + ox.session +
        '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
        '&userid=' + ox.user_id +
        '&cid=' + ox.context_id +
        '&epassword=' + encodeURIComponent(data.epass) +
        '&folder=' + data.parent.folder_id +
        '&download=true' +
        '&attname=' + encodeURIComponent(data.filename);
        var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
        $('#tmp').append(
                $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'download' + data.id })
        );
    }

    // Download encrypted inline attachment
    new links.Action('io.ox/mail/actions/download-OGPGPinline', {
        id: 'DownloadOGPGPinline',
        requires: function (e) {
            return isInline(e);
        },
        multiple: function (list) {
            _(list).each(function (data) {
                downloadInline (data);
            });
        }
    });

    function downloadInline (data) {
        var filename = data.filename.replace('.pgp', '');
        var params = '&emailid=' + data.parent.id +
        '&attach=' + data.id +
        '&session=' + ox.session +
        '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
        '&userid=' + ox.user_id +
        '&cid=' + ox.context_id +
        '&epassword=' + encodeURIComponent(data.epass) +
        '&folder=' + data.parent.folder_id +
        '&cc=' + data.cc +
        '&download=true' +
        '&attname=' + encodeURIComponent(filename);
        var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(filename) + '?action=getinlineattach' + params;
        $('#tmp').append(
                $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'download' + data.id })
            );
    }
    // Save decoded PGP attachment
    new links.Action('io.ox/mail/actions/save-OGPGPattachment', {
        id: 'SaveDecodedPGPAttachment',
        requires: function (e) {
            if (e.baton.data instanceof Array) {
                return (e.baton.data[0].pgpFormat !== undefined);
            }
            return (e.baton.data.pgpFormat !== undefined);
        },
        multiple: function (list) {
            require(['oxguard/pgp/saveattach'], function (action) {
                action.multiple(list, true);
            });
        }
    });
    // Save encrypted PGP attachment to drive
    new links.Action('io.ox/mail/actions/save-OGPGPEncrypted', {
        id: 'SaveDecodedPGPAttachment',
        requires: function (e) {
            if (e.baton.data instanceof Array) {
                return (e.baton.data[0].pgpFormat !== undefined);
            }
            return (e.baton.data.pgpFormat !== undefined);
        },
        multiple: function (list) {
            if (list[0].pgpFormat === 'pgpinline') {
                require(['io.ox/mail/actions/attachmentSave'], function (action) {
                    action.multiple(list);
                });
            } else {
                require(['oxguard/pgp/saveattach'], function (action) {
                    action.multiple(list, false);
                });
            }
        }
    });

    new links.Action('io.ox/mail/actions/open-OGPGPinline', {
        id: 'openOGPGPinline',
        requires: function (e) {
            return isInline(e);
        },
        multiple: function (list) {
            _(list).each(function (data) {
                var filename = data.filename.replace('.pgp', '');
                var params = '&emailid=' + data.parent.id +
                    '&attach=' + data.id +
                    '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    '&epassword=' + encodeURIComponent(data.epass) +
                    '&folder=' + data.parent.folder_id +
                    '&attname=' + encodeURIComponent(filename);
                var link = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(filename) + '?action=getinlineattach' + params;
                var popup = window.open(link);
                if (popup === null || popup === undefined) {
                    // If popup blocked, give one try to see if user notices, otherwise alert message regarding blocking
                    if (popupBlockCount === 1) {
                        require (['io.ox/core/notifications'], function (notifications) {
                            //#. Error message when trying to open a file with popup blocker on browser blocking
                            notifications.yell('error', gt('Your pop-up blocker may have prevented a Guard window that provides application functionality.'));
                        });
                        //  window.location.href = link;
                    }
                    popupBlockCount++;
                }
            });
        }
    });

    // test a single file if it is a key
    function testKey (file) {
        var test = {
                collection: null,
                context: file
            };
        return (isKey (test));
    }

    function isKey (e) {
        if (isASC(e)) {
            if (e.collection === null || e.collection.has('one')) { // only return true for individual files
                var type;
                var name;
                if (e.context instanceof Array) {
                    type = e.context[0].content_type;
                    name = e.context[0].filename;
                } else {
                    type = e.context.content_type;
                    name = e.context.filename;
                }
                if (type === 'application/pgp-keys') return true;
                if (name === 'public.asc') return true;
                return (/[0-9A-F]{8}\.asc/).test(name); // Regex for 8 hex.asc
            }
        }
        return false ;
    }

    ext.point('io.ox/mail/detail/attachments').extend({
        id: 'Import',
        draw: function (e) {
            var keyfound = false;
            e.attachments.forEach(function (a) {
                if (testKey(a)) {
                    keyfound = true;
                }
            });
            if (keyfound) {
                var keydiv = $('<div class="importKey">');
                var notice = $('<span>' + gt('PGP Public Key Found.  Click to Import') + '</span>');
                notice.click(function () {
                    doImportKey(e.attachments);
                });
                this.append(keydiv.append(notice));
            }
        }
    });

    new links.Action('io.ox/mail/actions/PGPPublicKey', {
        id: 'PGPKey',
        requires: function (e) {
            return isKey(e);
        },
        multiple: function (list) {
            doImportKey (list);
        }
    });

    function doImportKey (list) {
        if (settings.get('cryptoProvider') === 'mailvelope') {
            loadKeyToMailvelope(list);
            return;
        }
        if (window.oxguarddata.passcode === 'No Key') {
            require(['oxguard/oxguard_core'], function (core) {
                //FIXME: is this needed? Why?
                core.createKeysWizard()
                .done(function () {
                    loadPublicKey(list);
                });
            });
        } else {
            loadPublicKey(list);
        }
    }

    // Open PGP encrypted VCARD
    new links.Action('io.ox/mail/actions/save-VCard', {
        id: 'VCardOG',
        requires: function (e) {
            if (e.context instanceof Array) { return false; }
            if (e.context.content_type === undefined) { return false; }
            //FIXME:
            if (e.context.content_type.indexOf('text/vcard') > -1) {
                if (e.context.epass !== undefined) return true;
            }
            if (e.context.filename.indexOf('.vcf.pgp') > 0) return true ;
            return false;
        },
        multiple: function (list) {
            require (['settings!io.ox/core', 'io.ox/core/notifications'], function (coreConfig, notify) {
                _(list).each(function (data) {
                    var contact_folder = coreConfig.get('folder/contacts');
                    var params = '&emailid=' + data.parent.id +
                        '&attach=' + data.id +
                        '&session=' + ox.session +
                        '&userid=' + ox.user_id +
                        '&cid=' + ox.context_id +
                        '&epass=' + encodeURIComponent(data.epass) +
                        '&filename=' + encodeURIComponent(data.filename) +
                        '&contacts=' + contact_folder +
                        '&inline=' + (data.pgpFormat === 'pgpinline' ? 'true' : 'false') +
                        '&folder=' + data.parent.folder_id;
                    var link = ox.apiRoot + '/oxguard/pgpmail/?action=importvcard' + params;
                    http.get(link, params)
                    .done(function (d) {
                        if (d.trim() === 'Warn') {
                            notify.yell('success', gt('VCard imported with warnings'));
                        } else notify.yell('success', gt('VCard imported'));
                    })
                    .fail(function () {
                        notify.yell('error', gt('Failed to import vcard'));
                    });
                });
            });
        }
    });

    // Return true if of type PGP
    //FIXME: move to util module
    function isPGPAttach(e) {
        if (e.context instanceof Array) {
            for (var i = 0; i < e.context.length; i++) {
                if (e.context[i].pgpFormat !== undefined) return true;
                if (e.context[i].content_type === 'application/pgp-encrypted') return true;
            }
            return false;
        }
        if (e.context.pgpFormat !== undefined) return true;
        if (e.context.content_type === 'application/pgp-encrypted') return true;
        return false;
    }

    ext.point('io.ox/mail/actions/print').replace({
        id: 'default',
        requires: function (e) {
            // not on smartphones
            if (_.device('smartphone')) return false;
            if (settings.get('cryptoProvider') === 'mailvelope') {
                if (e.collection.has('one')) {
                    if (e.context.attachments) {
                        if (util.isEncryptedMail(e.context)) return false;
                    }
                }
            }
            // need some and either read access or being embedded
            return e.collection.has('some') && (e.collection.has('read') || !e.collection.has('toplevel'));
        },
        multiple: function (list) {
            require (['io.ox/core/print'], function (print) {
                var nonPGP = [];
                var isPGP = [];
                for (var i = 0; i < list.length; i++) {
                    if (list[i].PGPDecoded) {
                        isPGP.push(list[i]);
                    } else {
                        nonPGP.push(list[i]);
                    }
                }
                if (isPGP.length > 0) {
                    print.request('oxguard/pgp/pgpprint', isPGP);
                }
                if (nonPGP.length > 0) {
                    print.request('io.ox/mail/print', nonPGP);
                }
            });
        }
    });

    // Link within viewer to download an inline attachment
    new links.Action('io.ox/mail/actions/downloadInlineView', {
        id: 'viewertest',
        requires: function (e) {
            if (e.baton.model.get('pgpFormat') === 'pgpinline') return (true);
            return (false);
        },
        action: function (e) {
            e.data.mail = e.data.parent;
            downloadInline(e.data);
        }
    });

    new links.Action('io.ox/mail/actions/downloadMimeView', {
        id: 'viewerdownload',
        requires: function (e) {
            if (e.baton.model.get('pgpFormat') === 'pgpmime') return (true);
            return (false);
        },
        action: function (e) {
            e.data.mail = e.data.parent;
            downloadMime(e.data);
        }
    });

    ext.point('io.ox/core/viewer/toolbar/links/guard').extend(new links.Link({
        id: 'OGPGPDownloadInline',
        index: 200,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/downloadInlineView',
        mobile: 'lo'
    }));

    ext.point('io.ox/core/viewer/toolbar/links/guard').extend(new links.Link({
        id: 'OGPGPDownloadMime',
        index: 200,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/downloadMimeView',
        mobile: 'lo'
    }));

    ext.point('io.ox/core/viewer/toolbar/links/guard').extend(new links.Link({
        id: 'OGPGPSaveMimeDrive',
        index: 201,
        label: gt('Save Encrypted to Drive'),
        ref: 'io.ox/mail/actions/save-OGPGPEncrypted',
        mobile: 'lo'
    }));

    ext.point('io.ox/core/viewer/toolbar/links/guard').extend(new links.Link({
        id: 'OGPGPSaveMimeDriveDecoded',
        index: 201,
        label: gt('Save Decoded to Drive'),
        ref: 'io.ox/mail/actions/save-OGPGPattachment',
        mobile: 'lo'
    }));

    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPview',
        index: 200,
        label: gt('View'),
        ref: 'io.ox/mail/actions/view-OGPGPattachment',
        mobile: 'lo'
    }));

    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPInlineview',
        index: 200,
        label: gt('View'),
        ref: 'io.ox/mail/actions/view-OGPGPinline',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPopen',
        index: 200,
        label: gt('Open in browser'),
        ref: 'io.ox/mail/actions/open-OGPGPattachment',
        mobile: 'lo'
    }));

    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPdownload',
        index: 200,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/download-OGPGPattachment',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPSaveDecoded',
        index: 300,
        label: gt('Save Decoded to Drive'),
        ref: 'io.ox/mail/actions/save-OGPGPattachment',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPSaveEncryped',
        index: 300,
        label: gt('Save Encrypted to Drive'),
        ref: 'io.ox/mail/actions/save-OGPGPEncrypted',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPdownloadInline',
        index: 200,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/download-OGPGPinline',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGPGPOpenInline',
        index: 200,
        label: gt('Open in browser'),
        ref: 'io.ox/mail/actions/open-OGPGPinline',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'PGPPublicKeyAttach',
        index: 202,
        label: gt('Import as PGP Public Key'),
        ref: 'io.ox/mail/actions/PGPPublicKey',
        mobile: 'lo'
    }));

    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGVCard',
        index: 204,
        label: gt('Add to address book'),
        ref: 'io.ox/mail/actions/save-VCard',
        mobile: 'lo'
    }));

    /// Sent folder extensions

    ext.point('io.ox/mail/links/inline').extend(new links.Link({
        index: 101,
        prio: 'lo',
        id: 'pinlink',
        label: gt('Check assigned PIN'),
        ref: 'io.ox/mail/actions/pin',
        mobile: 'lo'
    }));

    var unified_sent = '';

    account.getUnifiedMailboxName().done(function (id) {
        require (['settings!io.ox/mail'], function (settings) {
            unified_sent = id + settings.get('defaultseparator', '/') + 'Sent';
        });
    });

    new links.Action('io.ox/mail/actions/pin', {
        id: 'statusaction',
        requires: function (e) {
            if (!(_.contains(account.getFoldersByType('sent'), e.context.folder_id)) && (e.context.folder_id !== unified_sent)) return (false);
            try {
                if (e.baton.data.headers === undefined) return (false);
                return (e.baton.data.headers['X-OxGuard-PIN'] !== undefined);
            } catch (ex) {
                console.log(ex);
                return (false);
            }
        },
        action: function (baton) {
            pin(baton);
        }
    });

    function pin (baton) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.ModalDialog({ width: 300, center: true, enter: 'ok' });
            dialog.header($('<h4>').text(gt('PIN')));
            var pin = baton.data.headers['X-OxGuard-PIN'];
            var pintext = $('<h2>').append(pin);
            dialog.getBody().append(pintext);
            dialog.addPrimaryButton('ok', gt('OK'), 'ok').show();
        });
    }

    ////////// End extensions
    /// Functions

    // Load keys into mailvelope
    function loadKeyToMailvelope (list) {
        require (['mailvelope/main', 'io.ox/mail/api'], function (api, mailAPI) {
            _(list).each(function (data) {
                if (testKey(data)) { // make sure key
                    return $.ajax({ url: mailAPI.getUrl(data, 'view'), dataType: 'text' }).then(function (text) {
                        api.getKeyring().then(function (keyring) {
                            keyring.importPublicKey(text);
                        });
                    });
                }
            });
        });
    }

    // Save public key from attachment
    function loadPublicKey (list) {
        _(list).each(function (data) {
            if (testKey(data)) { // make sure key
                var params = '&emailid=' + data.parent.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&folder=' + data.parent.folder_id;
                if (data.pgpFormat !== undefined) { //If encrypted
                    params = params + '&epass=' + encodeURIComponent(data.epass) +
                        '&inline=' + ((data.pgpFormat === 'pgpinline') ? 'true' : 'false') +
                        '&filename=' + encodeURIComponent(data.filename);
                }
                var link = ox.apiRoot + '/oxguard/pgpmail/?action=savepublicattach' + params;
                http.get(link, '')
                .done(function (data) {
                    require(['io.ox/core/notifications'], function (notify) {
                        var keys = JSON.parse(data);
                        var added = gt('Added keys: \r\n');
                        for (var i = 0; i < keys.length; i++) {
                            added = added + gt('Key ID: ') + keys[i].Key + ' ' + keys[i].ids + '\r\n';
                        }
                        notify.yell('success', added);
                    });
                })
                .fail(function (e) {
                    console.log(e);
                    require(['io.ox/core/notifications'], function (notify) {
                        if (e.status === 503) {
                            notify.yell('error', gt('Service Unavailable'));
                        } else
                            notify.yell('error', e.responseText);
                    });
                });
            }
        });
    }
});
