/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/pgp/reader', [
    'io.ox/core/extensions',
    'oxguard/core/og_http',
    'gettext!oxguard'
], function (ext, http, gt) {
    'use strict';

    var pgpclass = 'icon-lock fa fa-lock pgp_superscript';

    function getId (baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1);
        } catch (e) {}
        return (id);
    }

    function decoding (baton) {
        var eid = getId(baton);
        baton.view.$el.find('.error').remove();
        baton.view.$el.find('.content').replaceWith('<div class="content" id="content' + eid + '" style="padding-top:20px;width:100px;margin-left:auto;margin-right:auto;">' + gt('Decoding') + '<i class="fa fa-spinner fa-spin" style="margin-left:10px;"></i></div><div class="error" id="error' + eid + '"/>');
    }

    function getInline (baton, password, index, auth, repeat) {
        var deferred = $.Deferred();
        var json = {
            password: password,
            session: ox.session,
            auth: window.oxguarddata.passcode
        };
        var params = '&folder=' + baton.data.folder_id + '&index=' + index +
            '&userid=' + ox.user_id + '&cid=' + ox.context_id + '&password=' +
            '&session=' + ox.session + '&emailid=' + baton.data.id + '&auth=' +
            encodeURIComponent(auth === undefined ? window.oxguarddata.passcode : auth);

        decoding(baton);
        // Send the request to the oxguard server
        http.post(ox.apiRoot, '/oxguard/pgpmail?action=getinline' + params, json)
        .done(function (data) {
            data = JSON.parse(data);
            var attachments = baton.view.model.get('attachments');
            for (var i = 0; i < attachments.length; i++) {
                if (attachments[i].disp === 'inline' && attachments[i].content_type.indexOf('text') > -1) {
                    if (attachments[i].content_type.indexOf('html') > -1) {
                        attachments[i].content = data.newcontent;
                        baton.data.replytext = data.newcontent;
                        baton.data.replytype = 'text/html';
                    } else {
                        attachments[i].content = convertToHTML(data.newcontent);
                        baton.data.replytext = convertToHTML(data.newcontent);
                        baton.data.replytype = 'text/plain';
                    }
                }
                attachments[i].epass = data.epassword;
                attachments[i].pgpFormat = 'pgpinline';
                if (attachments[i].filename !== undefined) {
                    attachments[i].filename = attachments[i].filename.replace('.pgp', '');
                    attachments[i].meta = {
                        previewUrl: getInlinePreviewUrl(attachments[i])
                    };
                }
            }
            var headers = baton.view.model.get('headers');
            if (headers['X-To-Recips'] !== undefined) {
                baton.view.model.set('to', stringToArray(headers['X-To-Recips']));
            }
            if (headers['X-CC-Recips'] !== undefined) {
                baton.view.model.set('cc', stringToArray(headers['X-CC-Recips']));
            }
            baton.view.model.set('attachments', attachments);
            baton.view.model.set('PGPDecoded', true);
            baton.view.model.set('pgpFormat', 'pgpinline');
            baton.view.model.set('PGP', true);
            baton.view.model.set('PGPresults', data.results);
            baton.data.attachments = attachments;
            baton.data.PGPDecoded = true;
            baton.data.pgpFormat = 'pgpinline';
            baton.view.expand();
            baton.model = baton.view.model;  // Unlike Guard, we can have main model reflect the changes.
            baton.view.loaded = true;
            baton.view.$el.empty();// Clear out the old template email data
            baton.view.redraw();
            window.oxguarddata.current = JSON.parse(JSON.stringify(baton.data));
            baton.view.model.set('Guard', JSON.parse(JSON.stringify(baton.data)));
            addIcons(baton);

        })
        .fail(function (data) {
            if (data.responseText.trim() === 'Bad RSA') {  // If server returns bad rsa, then problems with encrypting password.  Try without pubkey
                if (repeat !== true) {
                    window.oxguarddata.pubkey = null;
                    getInline (baton, password, index, auth, true);
                    return;
                }
            }
            require (['oxguard/oxguard_core'], function (core) {
                var goFunction = function (id) {
                    var password = ($('#oxgrpass' + id).val() === undefined) ? '' : $('#oxgrpass' + id).val();
                    decoding(baton);
                    require (['oxguard/pgp/reader'], function (reader) {
                        reader.getInline(baton, password, index, auth);
                    });
                };
                core.handleFailEmail (data, baton, deferred, goFunction);
            });
        });
        return (deferred);
    }

    var regIsImage = /\.(gif|bmp|tiff|jpe?g|gmp|png)$/i;

    function convertToHTML (text) {
        return (text.replace(/</g, '&lt').replace(/>/g, '&gt').replace(/\n/g, '<br>'));
    }

    function getInlinePreviewUrl (data) {
        try {
            if (!regIsImage.test(data.filename)) return (null);
            var params = '&emailid=' + data.parent.id +
            '&attach=' + data.id +
            '&session=' + ox.session +
            '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
            '&userid=' + ox.user_id +
            '&cid=' + ox.context_id +
            '&epassword=' + encodeURIComponent(data.epass) +
            '&folder=' + data.parent.folder_id +
            '&attname=' + encodeURIComponent(data.filename);
            return (ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getinlineattach' + params);
        } catch (e) {
            console.log(e);
            return null;
        }

    }
    function stringToArray (list) {
        var array = [];
        var addresses = list.split(',');
        addresses.forEach (function (e) {
            var i = e.indexOf('<');
            if (i > 0) {
                var name = e.substring (0, i);
                var email = e.substring (i).replace('<', '').replace('>', '');
                var arr = [name, email];
                array.push(arr);
            }
        });
        return (array);
    }

    function getPGP(baton, password, index, auth, repeat) {
        var deferred = $.Deferred();
        var json = {
            password: password,
            session: ox.session,
            auth: window.oxguarddata.passcode
        };
        var params = '&folder=' + baton.data.folder_id +
            '&userid=' + ox.user_id + '&cid=' + ox.context_id +
            '&session=' + ox.session + '&emailid=' + baton.data.id + '&auth=' +
            encodeURIComponent(auth === undefined ? window.oxguarddata.passcode : auth);

        decoding(baton);
        // Send the request to the oxguard server
        http.post(ox.apiRoot,'/oxguard/pgpmail?action=getmail' + params, json)
        .done(function (data) {
            try {
                data = JSON.parse(data);
                baton.data.attachments = data.attachments;
                baton.data.PGPresults = data.results;
                baton.data.content_type = 'multipart/mixed';
                baton.data.PGPDecoded = true;
                var attachment = false;
                for (var i = 0; i < data.attachments.length; i++) {
                    data.attachments[i].epass = data.results.epassword;
                    data.attachments[i].pgpFormat = 'pgpmime';
                    var type = data.attachments[i].content_type;
                    if ((type.indexOf('text') > -1) || (type.indexOf('alternative') > -1)) {// find text attachment
                        data.attachments[i].content = replace_content_id(data.attachments[i].content, data.results.epassword, baton.data);
                        if (type === 'alternative') {
                            type = 'text/html';
                            data.attachments[i].content_type = type;
                        }
                        if (type === 'text/plain') {
                            data.attachments[i].content = convertToHTML(data.attachments[i].content);  // Gets displayed in HTML window, so convert lf to <br>, etc
                        }
                        if (data.attachments[i].disp === 'inline') {
                            baton.data.replytext = data.attachments[i].content;
                            baton.data.replytype = type;
                        } else attachment = true;
                    } else attachment = true;
                    if (data.attachments[i].filename !== undefined) {
                        data.attachments[i].meta = {
                            previewUrl: getMimePreviewUrl(baton.data, data.attachments[i])
                        };
                    }
                }
                baton.view.model.set('attachment', attachment);
                baton.view.model.set('attachments', data.attachments);
                baton.view.model.set('pgpFormat', 'pgpmime');
                baton.view.model.set('to', data.to);
                baton.view.model.set('cc', data.cc);
                baton.view.model.set('PGPDecoded', true);
                baton.view.model.set('PGP', true);
                baton.view.model.set('PGPresults', data.results);
                baton.data.attachment = attachment;
                baton.data.to = data.to;
                baton.data.pgpFormat = 'pgpmime';
                baton.view.expand();
                baton.view.loaded = true;
                baton.view.$el.empty();// Clear out the old template email data
                baton.view.redraw();
                window.oxguarddata.current = JSON.parse(JSON.stringify(baton.data));
                baton.view.model.set('Guard', JSON.parse(JSON.stringify(baton.data)));
                addIcons (baton);

            } catch (e) {
                console.log('Failed to decode PGP ' + e);
                require (['oxguard/oxguard_core'], function (core) {
                    var data = {
                        responseText: 'Error'
                    };
                    core.handleFailEmail (data, baton, deferred, null);
                });
            }
        })
        .fail (function (data) {
            if (data.responseText.trim() === 'bad rsa') { // If server returns bad rsa, then problems with encrypting password.  Try without pubkey
                if (repeat !== true) {
                    window.oxguarddata.pubkey = null;
                    getPGP(baton, password, index, auth, true);
                    return;
                }
            }
            require (['oxguard/oxguard_core'], function (core) {
                var goFunction = function (id) {
                    var password = ($('#oxgrpass' + id).val() === undefined) ? '' : $('#oxgrpass' + id).val();
                    decoding(baton);
                    require (['oxguard/pgp/reader'], function (reader) {
                        reader.getPGP(baton, password);
                    });
                };
                core.handleFailEmail (data, baton, deferred, goFunction);
            });
        });
        return (deferred);
    }

    function getMimePreviewUrl (mail, data) {
        try {
            if (!regIsImage.test(data.filename)) return (null);
            var params = '&emailid=' + mail.id +
            '&attach=' + data.id +
            '&session=' + ox.session +
            '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
            '&userid=' + ox.user_id +
            '&cid=' + ox.context_id +
            '&epassword=' + encodeURIComponent(data.epass) +
            '&folder=' + mail.folder_id +
            '&attname=' + encodeURIComponent(data.filename);
            return (ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params);
        } catch (e) {
            console.log(e);
            return (null);
        }
    }
    // Find cid links in body of email and replace with Guard links
    function replace_content_id (content, epass, data) {
        content = content.replace(/cid:[^@]+@GUARD/, function (c) {
            var params = '&emailid=' + data.id +
            '&session=' + ox.session +
            '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
            '&userid=' + ox.user_id +
            '&cid=' + ox.context_id +
            '&epassword=' + encodeURIComponent(epass) +
            '&folder=' + data.folder_id +
            '&content_id=' + encodeURIComponent(c.substring(4));
            var link = location.protocol + '//' + location.host + ox.apiRoot + '/oxguard/pgpmail/inline?action=getattachcid' + params;
            return (link);
        });
        return (content);
    }

    function addIcons (baton) {
        if (baton.view.$el.find('.oxguard_icon_fa').length > 0) return;   // if already drawn, return
        var data = baton.view.model.get('PGPresults');
        var flagpicker = baton.view.$el.find('.flag-picker');
        var signedicon = null;
        if (data.verified !== undefined) {
            if (data.verified) {
                var signedicon = $('<i class="oxguard_icon_fa fa-pencil-square-o fa" aria-hidden="true" title="' + gt('This Email was signed and verified') + '"/>');
                flagpicker.after(signedicon);
            } else {
                if (data.signature && !data.verified) {
                    if (data.missingPublicKey) {
                        signedicon = $('<i class="oxguard_icon_fa fa-pencil-square-o fa guard_signed" style="color:lightgrey" aria-hidden="true" title="' + gt('This Email was signed but unable to verify') + '"/>');
                    } else
                        signedicon = $('<i class="oxguard_icon_fa_alert fa-pencil-square fa" aria-hidden="true" title="' + gt('This Email was signed and failed verification') + '"/>');
                    flagpicker.after(signedicon);
                }
            }
        }
        var pgp = $('<div class="oxguard_icon_fa" title="' + gt('This Email was encrypted with PGP.') + '"/>');
        if (_.device('small')) {  // Formatting for mobile
            pgp.css('margin-right', '20px');
            if (signedicon !== null) signedicon.css('margin-top', '-3px');
        } else {
            pgp.css('margin-right', '-9px').css('padding-top', '3px');
            if (signedicon !== null) signedicon.css('margin-top', '1px');
        }

        pgp.append('P<span style="font-size:0.5em;">gp</span>');
        var lockicon = $('<i class="' + pgpclass + '" aria-hidden="true"/>');
        pgp.append(lockicon);
        flagpicker.after(pgp);
    }

    return {
        getInline: getInline,
        addIcons: addIcons,
        getPGP: getPGP
    };
});
