/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/upsell', [
    'oxguard/core/og_http'
], function (http) {
    'use strict';

    var adding = false;

    // Add upsell message to header of email
    function upsell(location) {
        var params = '&cid=' + ox.context_id + '&id=' + ox.user_id + '&lang=' + ox.language;
        if (adding) return;
        adding = true;
        http.get(ox.apiRoot + '/oxguard/mail?action=upsell', params)
        .done(function (data) {
            var upsellDiv = $('<div class="guardUpsell"></div>').append(data);
            location.find('.detail-view-header').after(upsellDiv);
        })
        .always(function () {
            adding = false;
        });
    }

    return {
        upsell: upsell
    };
});
