/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/oxguard_mail_compose_core', [
    'io.ox/core/extensions',
    'oxguard/core/og_http',
    'io.ox/core/notifications',
    'oxguard/util',
    'io.ox/core/tk/dialogs', 'gettext!oxguard'
], function (ext, og_http, notify, util, dialogs, gt) {
    'use strict';

    var guesticon = '<i id="newguest" class="fa fa-male oxguard_token" style="color:#5DCD55;" title="' + gt('Will create new guest account for Guard') + '"/>';
    //#. Have encryption key - Shown on icon hover when a key symbol is displayed for recipient.  We/Guard have an encryption key for the recipient.
    var keyicon = '<i class="fa fa-key oxguard_token oxguard_lock" aria-hidden="true" title="' + gt('Have encryption key') +'"></i>';
    var failicon = '<i id="newguest" class="fa fa-ban oxguard_token" style="color:red;" title="' + gt('Will create new guest account for Guard') + '"/>';
    var prompting = false;

    // 7.8 compose code

    function drawKeyIcons(result, location) {
        var input = $(location).parent().find('.token-input');
        var inputwidth = input.width() - 30;
        switch (result) {
        case 'pgp' :
            $(location).find('.close').before(keyicon);
            break;
        case 'guest' :
            $(location).find('.close').before(guesticon);
            break;
        case 'fail' :
            $(location).find('.close').before(failicon);
            break;
        }
        input.width(inputwidth);
    }

    // Return a has of string
    function hash(str) {
        var hashed = 0;
        if (str.length === 0) return hashed;
        for (var i = 0; i < str.length; i++) {
            hashed = (31 * hashed + str.charCodeAt(i)) << 0;
        }
        return hashed;
    }

    function checkrecipient(baton) {
        if (!util.isGuardConfigured()) {
            if (!prompting) {
                prompting = true;
                require(['oxguard/oxguard_core'], function (core) {
                    core.createKeysWizard()
                    .done(function () {
                        checkrecipient(baton);
                    })
                    .fail(function () {
                        unlock(baton);
                    })
                    .always(function () {
                        prompting = false;
                    });
                });
            }
            return;// Do not check recipients until the master key is created (in case mailing to self)
        }
        require(['oxguard/mail/keymanager'], function (keyman) {
            keyman.checkAll(baton);
        });
    }

    function unlock(baton) {
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send'));
        } else {
            var headerview = baton.view.app.get('window').nodes.header;
            headerview.find('.btn-primary:visible').html(gt('Send'));
        }
        baton.view.$el.find('.oxguard_key').hide();
        baton.view.$el.find('.oxguard_token').hide();
        baton.view.model.set('encrypt', false);
        var format = baton.view.model.get('PGPFormat');
        if (format === 'inline' || format === 'i') {  // Deactivate the Format types if not encrypted
            baton.view.model.set('PGPFormat', 'i');
        } else {
            baton.view.model.set('PGPFormat', 'm');
        }
    }

    function lock(baton) {

        if (baton.app) {
            if (baton.app.autosave) {
                window.clearTimeout(baton.app.autosave.timer);
            }
        }
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send Secure'));
        } else {
            var headerview = baton.view.app.get('window').nodes.header;
            headerview.find('.btn-primary:visible').html(gt('Send Secure'));
        }
        checkrecipient(baton);
        baton.view.$el.find('.oxguard_key').show();
        baton.view.$el.find('.oxguard_token').show();
        baton.view.model.set('encrypt', true);
        updateTokens(baton);
        var format = baton.view.model.get('PGPFormat');
        if (format === 'i') {  // Activate the Format types if encrypted
            baton.view.model.set('PGPFormat', 'inline');
        } else {
            if (format === 'm') baton.view.model.set('PGPFormat', 'mime');
        }
    }

    function updateTokens(baton) {
        baton.model.trigger('change:to', baton.model, baton.model.get('to'));
        baton.model.trigger('change:cc', baton.model, baton.model.get('cc'));
        baton.model.trigger('change:bcc', baton.model, baton.model.get('bcc'));
    }

    return {
        checkRecip: function (baton) {
            checkrecipient(baton);
        },
        lock: lock,
        hash: hash,
        unlock: unlock,
        drawKeyIcons: drawKeyIcons
    };
});
