/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/core/og_http', [
], function () {
    'use strict';

    function doPost (url, params, data) {
        var def = $.Deferred();
        if (data === null || data === undefined) data = {};
        var t0 = _.now();
        $.post(url + params, JSON.stringify(data), function (rdata) {
            def.resolve(rdata);
            if ((_.now() - t0) > 1000) {
                require (['oxguard/core/log'], function (log) {
                    log.slow ((_.now() - t0), url, params, data);
                });
            }
        })
        .fail (function (r) {
            require (['oxguard/core/log'], function (log) {
                log.fail(r, url, params, data);
            });
            def.reject(r);
        });
        return (def);
    }

    // Look for passwords in outgoing data.  If able, encrypt
    function post (url, params, data) {
        var def = $.Deferred();
        require (['oxguard/crypto/encr'], function (encr) {
            if (window.oxguarddata && window.oxguarddata.pubkey !== undefined && data !== undefined) {
                if (data.password !== undefined) {
                    if (data.password !== '') {
                        var epass = encr.cryptPass(data.password);
                        if (epass !== null) {
                            data.e_password = epass;
                            delete data.password;
                        }
                    }
                }
                if (data.ox_password !== undefined) {
                    if (data.ox_password !== '') {
                        var oxpass = encr.cryptPass(data.ox_password);
                        if (oxpass !== null) {
                            data.e_ox_password = oxpass;
                            delete data.ox_password;
                        }
                    }
                }
                if (data.encr_password !== undefined) {
                    if (data.encr_password !== '') {
                        var encrpass = encr.cryptPass(data.ox_password);
                        if (encrpass !== null) {
                            data.e_encr_password = encrpass;
                            delete data.encr_password;
                        }
                    }
                }
                if (data.extrapass !== undefined) {
                    if (data.extrapass !== '') {
                        var expass = encr.cryptPass(data.extrapass);
                        if (expass !== null) {
                            data.e_extrapass = expass;
                            delete data.extrapass;
                        }
                    }
                }
            }
            doPost (url, params, data)
            .done (function (e) {
                def.resolve(e);
            })
            .fail (function (f) {
                def.reject(f);
            });
        });
        return (def);
    }

    function get (url, params) {
        var def = $.Deferred();

        var t0 = _.now();
        $.get(url + params, function (rdata) {
            def.resolve(rdata);
            if ((_.now() - t0) > 1000) {
                require (['oxguard/core/log'], function (log) {
                    log.slow ((_.now() - t0), url, params, {});
                });
            }
        })
        .fail (function (r) {
            require (['oxguard/core/log'], function (log) {
                log.fail(r, url, params, {});
            });
            def.reject(r);
        });

        return (def);
    }

    return {
        post: post,
        get: get
    };
});
