/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2015
 */

define('mailvelope/sync/uploader', [
'oxguard/core/og_http',
'mailvelope/main'
], function (og_http, api) {
    'use strict';

    function getPublicKey (emailAddr) {
        var def = $.Deferred();
        api.getKeyring().then(function (keyring) {
            keyring.exportOwnPublicKey(emailAddr)
            .then(function (data) {
                def.resolve (data);
            }, function () {
                def.reject('error');
            });
        });
        return (def);
    }

    function uploadPublic (emailAddr) {
        var def = $.Deferred();
        getPublicKey(emailAddr)
        .done(function (data) {
            var params = '&session=' + ox.session;
            var data = {
                userid: ox.user_id,
                cid: ox.context_id,
                keydata: data,
                email: emailAddr
            };
            og_http.post(ox.apiRoot + '/oxguard/mailvelope?action=uploadpublic', params, data)
            .done(function () {
                def.resolve();
            })
            .fail(function (e) {
                console.log(e);
                def.reject(e.responseText);
            });

        })
        .fail(function () {
            def.reject('empty');
        });
        return (def);
    }

    return {
        uploadPublic: uploadPublic
    };

});
