/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('mailvelope/settings', [
    'io.ox/core/extensions',
    'oxguard/util',
    'mailvelope/main',
    'io.ox/core/folder/api',
    'gettext!oxguard',
    'settings!oxguard'
], function (ext, util, api, folderAPI, gt, settings) {
    'use strict';

    var point = ext.point('io.ox/settings/pane/main/oxguard');

    settings.on('change:cryptoProvider', updateExtensions);
    api.once('setup:done', function () {
        updateExtensions(null, 'mailvelope');
    });

    function updateExtensions (m, provider) {
        point.disable('mailvelope');
        return util.hasSetupDone().then(function () {
            if (provider === 'mailvelope') {
                point.enable('mailvelope');
            }
        }).always(function () {
            require(['io.ox/settings/main']).then(function (s) {
                var app = s.getApp();

                if (!_.isFunction(app.setSettingsPane)) return;

                //redraw settings pane/tree
                app.setSettingsPane({
                    folder: 'virtual/settings/oxguard'
                });
            });
        });
    }

    function initAdvancedSettings() {
        var provider = settings.get('cryptoProvider');

        point.extend({
            title: gt('Mailvelope Advanced'),
            id: 'mailvelope',
            loadSettingPane: true,
            index: 100
        });

        updateExtensions(settings, provider);
    }

    initAdvancedSettings();

});
