/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.setup;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonObject;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.OGInit;
import com.openexchange.guard.database.Sharding;
import com.openexchange.guard.util.Core;

public class RegisterDb {
	private static Logger logger = LoggerFactory.getLogger(RegisterDb.class);
    /**
     * Register in configDb a new database
     * 
     * @param dbcon
     * @param wurl
     * @param rurl
     * @param driver
     * @param login
     * @param password
     * @param name
     * @throws Exception 
     */
    public static void register(Connection dbcon, String wurl, String rurl, String driver, String login, String password, String name) throws Exception {
        Statement stmt = dbcon.createStatement();
        String suffix = "?useUnicode=true&characterEncoding=UTF-8&autoReconnect=false&useUnicode=true&useServerPrepStmts=false&useTimezone=true&serverTimezone=UTC&connectTimeout=15000&socketTimeout=15000";
        String command = "SELECT db_pool_id FROM db_pool WHERE name = '" + name + "'";
        ResultSet rs = stmt.executeQuery(command);
        if (rs.next()) { // If already registered, just exit
            rs.close();
            stmt.close();
            return;
        }
        rs.close();
        command = "START TRANSACTION";
        stmt.execute(command);
        int writeint = getNext(stmt, rs);
        if (writeint == 0) {
            command = "ROLLBACK";
            stmt.execute(command);
            stmt.close();
        	throw (new Exception ("Unable to get next from configdb"));
        }
        try {
        command = "INSERT INTO db_pool VALUES (" + (writeint) + ",'" + wurl + suffix + "', '" + driver + "', '" + login + "', '" + password + "', 1, 100, 0, '" + name + "');";
        OGInit.write_map.put(name, writeint);  // Update map
        mysqlExecute(command, dbcon);
        int read = 0;
            if (rurl != null) {
            	read = getNext(stmt, rs);
                if (read == 0) {
                    command = "ROLLBACK";
                    stmt.execute(command);
                    stmt.close();
                	throw (new Exception ("Unable to get next from configdb"));
                }
                command = "INSERT INTO db_pool VALUES (" + (read) + ",'" + rurl + suffix + "', 'com.mysql.jdbc.Driver', '" + login + "', '" + password + "', 1, 100, 0, '" + name + "');";
                mysqlExecute(command, dbcon);
                OGInit.read_map.put(name, read);
            } else OGInit.read_map.put(name, writeint);
            
        int nextc = getNext(stmt, rs);
        if (nextc == 0) {
            command = "ROLLBACK";
            stmt.execute(command);
            stmt.close();
        	throw (new Exception ("Unable to get next from configdb"));
        }
        command = "INSERT INTO db_cluster VALUES (" + nextc + ", " + read + ", " + writeint + ", 100, 0)";
        mysqlExecute(command, dbcon);
        command = "COMMIT";
        stmt.execute(command);
        stmt.close();
        initDatabase(writeint, name);
        } catch (Exception ex) {
        	logger.error("Unable to register database in configdb " , ex);
        	command = "ROLLBACK";
            stmt.execute(command);
            stmt.close();
            throw (new Exception ("Unable to create next configdb"));
        }
    }

    private static void mysqlExecute(String command, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute(command);

    }
    
    private static int getNext(Statement stmt, ResultSet rs) throws SQLException {
        String command = "UPDATE configdb_sequence SET id=last_insert_id(id+1)";
        stmt.execute(command);
        command = "SELECT last_insert_id() as id";
        rs = stmt.executeQuery(command);
        int next = 0;
        if (rs.next()) {
        	next = rs.getInt("id");
        }
        rs.close();
        return (next);
    }
    
    public static JsonObject initDatabase(int write, String database) throws Exception {

        JsonObject result = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpContext context = HttpClientContext.create();
        String url = "http" + (Config.backend_ssl ? "s" : "") + "://" + Config.getOxBackend() + ":" + Config.ox_backend_port + "/preliminary/database/v1/init/w/" + write + "/" + database;
        HttpGet getRequest = new HttpGet(url);
        getRequest.addHeader("accept", "application/json");
        getRequest.addHeader("Authorization", "Basic " + Config.getBasicAuthenticationEncoding());
        CloseableHttpResponse response = httpClient.execute(getRequest, context);
        if (response.getStatusLine().getStatusCode() != 200) {
            JsonObject resp = null;
            try {
                resp = Core.getJson(response);
            } catch (Exception ex) {
                throw new Exception("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }

        response.close();
        httpClient.close();
        return (result);

    }
    

}
