package com.openexchange.guard.pgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;


public class PGPPublicKeyRingExporter {

    public static String export(PGPPublicKeyRing pubring) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream arm = new ArmoredOutputStream(out);
        Iterator<PGPPublicKey> keys = pubring.getPublicKeys();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while (keys.hasNext()) {
            PGPPublicKey k = keys.next();
            k.encode(bout);
        }
        arm.write(bout.toByteArray());
        arm.close();
        bout.close();
        out.close();
        return (new String(out.toByteArray()));
    }
}
