package com.openexchange.guard.ox.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;


public class GuardStreamDecryptionHandler implements StreamHandler{

    private final int userId;
    private final int cid;
    private final String password;
    private final String encryptedExtraPassword;
    private final String sessionId;

    /**
     * Constructor
     * @param userId The user's ID
     * @param cid The content id
     * @param password the user's password
     * @param extraPassword an encrypted, optional, additional password which was set for the file
     */
    public GuardStreamDecryptionHandler(int userId,
                                        int cid,
                                        String password,
                                        String encryptedExtraPassword,
                                        String sessionId){
        this.userId = userId;
        this.cid = cid;
        this.password = password;
        this.encryptedExtraPassword = encryptedExtraPassword;
        this.sessionId = sessionId;
    }

    @Override
    public void processStream(InputStream inputStream,
                              OutputStream outputStream,
                              int suggestedBufferSize) throws IOException {

        try {
            //By now we read the entire stream into memory
            //since the underlying decryption method does not support
            //the decryption of a stream
            EncryptedObj encryptedObject = new EncryptedObj(inputStream);

            //Decrypt the object
            Crypto crypto = new Crypto();
            String stringContent = crypto.decodeEncrObj(userId,
                                                        cid,
                                                        encryptedObject,
                                                        password);

            //Checking if the file was encrypted using an extra password
            if(stringContent.startsWith("EXTRA")){
                //Data was protected with an additional password
                EncrLib encr = new EncrLib();
                String extraPassword = encr.decryptAES(encryptedExtraPassword,
                                               sessionId,
                                               "epass",
                                               Config.AESKeyLen);
                stringContent = encr.decryptAES(stringContent.substring(5),
                                                extraPassword,
                                                encryptedObject.ItemID,
                                                encryptedObject.keyLength);
                if (stringContent.length() < 2) {
                    throw new IOException("Incorrect password");
                    //TODO i18n:
                    //ERROR HANDLING + i18n
                    //sendOK(response, GetText.gettext("Incorrect password", lang));
                }
            }

            //
            //TODO: Check for status: ?
            //TODO: Check for exceeded ?

            //Writing the decrypted content to outptut stream
            byte decryptedContent[] =
                Base64.decodeBase64(stringContent);
            outputStream.write(decryptedContent);

        } catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getNewContentType(String oldContentType, String fileName) {
        return oldContentType.replace("grd/", "").replace("--", "/");
    }

    @Override
    public String getNewName(String oldName) {
        return oldName.replace(".grd2", "").replace(".grd", "");
    }
}
