package com.openexchange.guard.mail;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.bouncycastle.openpgp.PGPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonObject;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.exceptions.BadPasswordException;
import com.openexchange.guard.exceptions.NoContentKeyException;
import com.openexchange.guard.exceptions.NoItemException;
import com.openexchange.guard.exceptions.NoMasterKeysException;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.server.CheckBad;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.util.Core;
import com.openexchange.guard.validator.Normalizer;

public class Getter {

	private static Logger logger = LoggerFactory.getLogger(Getter.class);
	 /**
     * Returns decrypted email
     * 
     * @param request
     * @param response
     * @param cookie
     * @throws Exception
     */
    public void getEncrEmail(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws Exception {
    	
    	JsonObject jdata = Core.getJSON(request);
    	
    	
        String emailid = Core.getStringFromJson(jdata, "emailid", true);
        int userid = Core.getIntFromJson(jdata, "userid");
        int cid = Core.getIntFromJson(jdata, "cid", true);
        int attachid = Core.getIntFromJson(jdata, "attach", true);
        String auth = Core.getStringParameter(request, "auth");
        String sessionID = Core.getStringParameter(request, "session", true);
        String folder = Core.getStringFromJson(jdata, "folder", true);
        String extraPass = Core.getStringFromJson(jdata, "extrapass");
        
        // cc is contentKey.  not currently implemented.  For possible client side decode of contentKey
        // if implemented, should be encrypted between client and server
        String cc = Core.getStringFromJson(jdata, "cc");
        if (cc.equals("")) cc = null;
        //
        //
        if (CheckBad.isBad(Integer.toString(userid) + "-" + Integer.toString(cid) + "-" + emailid, Config.bad_password_count)) {
            com.openexchange.guard.util.Core.sendOK(response, "{\"Exceeded\" : " + Config.bad_minute_lock + "}");
            return;
        }
        UserData data;
        try {
            if (auth.length() < 20) {

                String password = Core.getStringFromJson(jdata, "password");
                if ((password == null) && (cc != null))
                    password = "";// if content key sent decoded, we don't need password. Remove null
                data = new UserData();
                data.encr_password = password;
                data.userid = userid;

            } else {
                long start = System.currentTimeMillis();
                data = new UserData(auth, cookie);
                logger.info("Auth decoded at " + start);
            }

            if ((data.userid == -1) || (data.encr_password == null)) {// Make sure our authorization is OK.
                com.openexchange.guard.util.Core.sendFail(response, "Bad authorization");
                CheckBad.addBad(Integer.toString(userid) + "-" + Integer.toString(cid) + "-" + emailid);
                return;
            }
            Crypto crypto = new Crypto();

            Api ap = new Api(cookie, sessionID, request.getHeader("User-Agent"));
            EncryptedObj emaildata = ap.getAttachment(emailid, attachid, folder);// Get the attachment from our orig email that contains
                                                                                 // encrypted email
            String email = crypto.decodeEncrObj(userid, cid, emaildata, data.encr_password, cc); // Decode it
            if (email != null) {
            	if (!email.equals("")) {
	                if ((auth.length() < 20) || extraPass != null) { // If we provided plaintext password or extrapass, we need to encrypt to
	                                                                 // return for attachments
	                    String extrap = "";
	                    String epassword = "";
	                    EncrLib encr = new EncrLib();
	                    Access acc = new Access();
	                    String token = acc.getToken(cookie.JSESSIONID);
	                    if (token == null)
	                        token = acc.newToken(cookie.JSESSIONID, userid, cid);
	                    if ((extraPass != null) && (email.length() > 10)) { // Extra pass, and not retracted/expired
	                        if (extraPass.length() > 2) {
	                            email = crypto.decodeExtraPass(email, extraPass, emaildata.ItemID, emaildata.keyLength);
	                            if (email.equals("")) {// If bad extra password
	                                com.openexchange.guard.util.Core.sendFail(response, "Bad extra");
	                                CheckBad.addBad(Integer.toString(userid) + "-" + Integer.toString(cid) + "-" + emailid);
	                                return;
	                            }
	                            extrap = encr.encryptAES(extraPass, token);
	                        }
	                    }
	                    epassword = encr.encryptAES(data.encr_password, token);
	                    email = "{" + "\"extrapass\":\"" + extrap + "\", \"epass\":\"" + epassword + "\"," + (email.startsWith("{") ? email.substring(1) : email); // add
	                                                                                                                                                               // extrapass
	                                                                                                                                                               // info
	                                                                                                                                                               // to
	                                                                                                                                                               // email
	                                                                                                                                                               // json
	                }
	                email = Normalizer.normalize(email);
	                logger.info("Success decode email");
	                response.addHeader("content-type", "text/html; charset=utf-8");
	                com.openexchange.guard.util.Core.sendOK(response, email);
	                return;
            	}
            }
        } catch (InvalidKeySpecException | NoSuchAlgorithmException | SQLException | PGPException e) {
        	logger.error("Error while decrypting email " + emailid + " for user " + cid + "/" + userid, e);
        }
        catch (NoItemException ni) {
        	logger.error("Item not found");
        	Core.sendFail(response, "noitem");
        	return;
        }
        catch (NoContentKeyException nc) {
        	logger.error("Content key not found");
        	Core.sendFail(response, "nocc");
        	return;
        }
        catch (NoMasterKeysException nk) {
        	logger.error("Unable to retrieve user keys");
        	Core.sendFail(response, "nokey");
        	return;
        }
        catch (BadPasswordException bp) {
        	CheckBad.addBad(Integer.toString(userid) + "-" + Integer.toString(cid) + "-" + emailid);
        	logger.info("Bad password");
        	Core.sendFail(response, "Bad Password");
        	return;
        }
        com.openexchange.guard.util.Core.sendFail(response, "Unable to decrypt");

    }
}
