package com.openexchange.guard.logging;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;

public class LogLayout extends LayoutBase<ILoggingEvent> {

    public String doLayout(ILoggingEvent event) {
        StringBuffer sbuf = new StringBuffer(128);
        sbuf.append("d=" + new Date(event.getTimeStamp()).toString() + ", ");
        sbuf.append("t=" + event.getThreadName() + ", ");
        sbuf.append("level=");
        sbuf.append(event.getLevel());
        sbuf.append(", ");
        sbuf.append(getMarkers(event));
        sbuf.append(getMDC(event));
        sbuf.append("module=" + event.getLoggerName().replace("com.openexchange.guard.", "") + ", ");
        sbuf.append("message=\"" + event.getFormattedMessage().replaceAll("\n", "\n\t") + "\"");
        IThrowableProxy thr = event.getThrowableProxy();
        if (thr != null) {
        	sbuf.append(getError(thr));
        }
        
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        return sbuf.toString();
    }
    
    // Get string from MDC values for logging
    private String getMDC (ILoggingEvent event) {
        Map<String, String> mdcs = new HashMap<String, String> ();
        try {
            mdcs.putAll(event.getMDCPropertyMap());
            if (mdcs.size() == 0) return ("");
            StringBuilder sb = new StringBuilder();
            // Add values in static order for better searching
            sb.append(addValue("PID", mdcs));
            sb.append(addValue("IP", mdcs));
            sb.append(addValue("ID", mdcs));
            sb.append(addValue("CID", mdcs));
            sb.append(addValue("result", mdcs));
            // If any other values, add here
            for (Map.Entry<String, String> entry : mdcs.entrySet())
            {
                sb.append(entry.getKey() + "=" + entry.getValue() + ", ");
            }
            return (sb.toString());
        } catch (Exception e) {
            return("ERROR GETTING LOG DATA");
        }
        
       
    }
    
    // Get a value from the map and return string for logging
    private String addValue (String key, Map mdcs) {
        String val = "";
        if (mdcs.containsKey(key)) {
            val = key + "=" + mdcs.get(key) + ", ";
            mdcs.remove(key);
        }
        return (val);
    }
    
    private String getMarkers (ILoggingEvent event) {
        if (event.getMarker() != null) {
            return ("marker=" + event.getMarker().getName() + ", ");
        }
        return ("");
    }
    
    private String getError (IThrowableProxy thr) {
    	StringBuilder sb = new StringBuilder();
    	sb.append(", error_class=" + thr.getClassName() + ", ");
    	sb.append("error_message=\"" + thr.getMessage() + "\", ");
    	sb.append("error_trace=\"");
    	StackTraceElementProxy [] st = thr.getStackTraceElementProxyArray();
    	for (StackTraceElementProxy pr : st) {
    		sb.append(pr.getSTEAsString() + "\r\n");
    	}
    	sb.append("\"");
    	return(sb.toString());
    }
}
