package com.openexchange.guard.database.pgpKeys;

import java.util.ArrayList;
import java.util.List;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.util.ListUtil;


public class RestDbPGPKeysStorage implements PGPKeysStorage {

    private final static String VALUES_LIST = "{@VALUES}";

    @Override
    public List<PGPKeys> getInternalByEmail(String email) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(PGPKeysSql.SELECT_BY_EMAIL_STMT);
            ArrayList<PGPKeys> ret = new ArrayList<PGPKeys>();
            command.addVariables(email);
            db.readOG(command);
            while(db.next()) {
                ret.add(new PGPKeys(db.rs.getLong("id"),
                                    db.rs.getString("email"),
                                    db.rs.getString("hexid"),
                                    db.rs.getInt("cid"),
                                    db.rs.getBit("local"),
                                    db.rs.getLong("keyid")));
            }
            return ret;
        }
        finally {
            db.close();
        }
    }

    @Override
    public PGPKeys getByHexId(String hexId) throws Exception {
        DbQuery db = new DbQuery() ;
        try {
            DbCommand command = new DbCommand(PGPKeysSql.SELECT_BY_HEXID_STMT);
            command.addVariables(hexId);
            db.readOG(command);
            if(db.next()) {
                return new PGPKeys(db.rs.getLong("id"),
                                   db.rs.getString("email"),
                                   db.rs.getString("hexid"),
                                   db.rs.getInt("cid"),
                                   db.rs.getBit("local"),
                                   db.rs.getLong("keyid"));
            }
            return null;
        }
        finally {
            db.close();
        }
    }

    @Override
    public PGPKeys getById(long id) throws Exception {
        DbQuery db = new DbQuery() ;
        try {
            DbCommand command = new DbCommand(PGPKeysSql.SELECT_BY_ID_STMT);
            command.addVariables(id);
            db.readOG(command);
            if(db.next()) {
                return new PGPKeys(db.rs.getLong("id"),
                                   db.rs.getString("email"),
                                   db.rs.getString("hexid"),
                                   db.rs.getInt("cid"),
                                   db.rs.getBit("local"),
                                   db.rs.getLong("keyid"));
            }
            return null;
        }
        finally {
            db.close();
        }
    }

    @Override
    public List<PGPKeys> getByIds(List<Long> ids) throws Exception {
        DbQuery db = new DbQuery();
        try {
            ArrayList<PGPKeys> ret = new ArrayList<PGPKeys>();
            String sql = PGPKeysSql.SELECT_BY_IDS_STMT;
            DbCommand command = new DbCommand(sql.replace(VALUES_LIST, ListUtil.listToDbValuesList(ids.size())));
            for(Long id : ids) {
                command.addVariables(id);
            }
            db.readOG(command);
            while(db.next()) {
                ret.add(new PGPKeys(db.rs.getLong("id"),
                                    db.rs.getString("email"),
                                    db.rs.getString("hexid"),
                                    db.rs.getInt("cid"),
                                    db.rs.getBit("local"),
                                    db.rs.getLong("keyid")));
            }
            return ret;
        }
        finally {
            db.close();
        }
    }

    @Override
    public PGPKeys getByKeyIdInContext(int contextId, long keyId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(PGPKeysSql.SELECT_BY_ID_IN_CONTEXT_STMT);
            command.addVariables(contextId);
            command.addVariables(keyId);
            db.readOG(command);
            if(db.next()) {
                return new PGPKeys(db.rs.getLong("id"),
                                   db.rs.getString("email"),
                                   db.rs.getString("hexid"),
                                   db.rs.getInt("cid"),
                                   db.rs.getBit("local"),
                                   db.rs.getLong("keyid"));
            }
            return null;
        }
        finally {
            db.close();
        }
    }

    @Override
    public void insertOrUpdate(long id, String email, String hexId, int contextId, long keyId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(PGPKeysSql.INSERT_OR_UPDATE_STMT);
            command.addVariables(id);
            command.addVariables(email);
            command.addVariables(hexId);
            command.addVariables(contextId);
            command.addVariables(1); //always create as "local"
            command.addVariables(keyId);
            command.addVariables(contextId);
            db.writeOxGuard(command);
        }
        finally {
            db.close();
        }
    }

    @Override
    public void deleteByKeyId(long keyId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(PGPKeysSql.DELETE_BY_KEYID_STMT);
            command.addVariables(keyId);
            db.writeOxGuard(command);
        }
        finally {
            db.close();
        }
    }

    @Override
    public void deleteByEmail(String email) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(PGPKeysSql.DELETE_BY_EMAIL_STMT);
            command.addVariables(email);
            db.writeOxGuard(command);
        }
        finally {
            db.close();
        }
    }

    @Override
    public void deleteByKeyIdInContext(long keyId, int contextId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(PGPKeysSql.DELETE_BY_KEYID_IN_CONTEXT_STMT);
            command.addVariables(contextId);
            command.addVariables(keyId);
            db.writeOxGuard(command);
        }
        finally {
            db.close();
        }
    }
}
