package com.openexchange.guard.database.keyCache;

/**
 * {@link KeyCacheStorage} provides access to pre generated PGP keys
 */
public interface KeyCacheStorage {

    /**
     * Inserts new pre-generated key data into the storage for later use
     * @param keyData the key data to insert
     */
    public void insert(String keyData) throws Exception;

    /**
     * Removes the next pre generated key from the key cache and returns it's data for key creation
     * @return the next pre generated key or null if no pre generated key is available
     */
    public String popNext() throws Exception;

    /**
     * @return the count of available pre generated keys
     */
    public int getCount() throws Exception;

}