package com.openexchange.guard.database.globalSettings;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;

/**
 * {@link RestDbGlobalSettingsStorage} provides a REST DB implementation of the GlobalSettingsStorage
 */
public class RestDbGlobalSettingsStorage implements GlobalSettingsStorage {

    private static Logger logger = LoggerFactory.getLogger(RestDbGlobalSettingsStorage.class);

    @Override
    public String getByKey(String key) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(GlobalSettingsSql.SELECT_STMT);
            command.addVariables(key);
            db.readOG(command);
            if(db.next()) {
                return db.rs.getString("value");
            }
            return null;
        }
        catch(Exception e) {
            logger.error("Error getting configuratin item " + key, e);
            throw e;
        }
        finally {
            db.close();
        }
    }

    @Override
    public void Update(String key, String value) throws Exception {
      DbQuery db = new DbQuery();
      try {
          DbCommand command = new DbCommand(GlobalSettingsSql.UPDATE_STMT);
          command.addVariables(value);
          command.addVariables(key);
          db.writeOxGuard(command);
      }
      catch(Exception e) {
          logger.error("Error updating configuratin item (" + key + ", " + value + ")", e);
          throw e;
      }
      finally {
          db.close();
      }
    }
}
