package com.openexchange.guard.database.bad;

import java.sql.Timestamp;

/**
 *
 * {@link Bad} represents a bad login attempts for a session
 */
public class Bad {

    private String id;
    private Timestamp last;
    private Timestamp currentTime;
    private int count;

    /**
     * Initializes a new {@link Bad}.
     * @param id the id of the session
     * @param last the last failed login attempt
     * @param currentTime the current time
     * @param count the amount of failed login attempts for the session
     */
    public Bad(String id, Timestamp last, Timestamp currentTime,int count) {
        this.id = id;
        this.last = last;
        this.currentTime = currentTime;
        this.count = count;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Timestamp getLast() {
        return last;
    }

    public void setLast(Timestamp last) {
        this.last = last;
    }

    public Timestamp getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(Timestamp currentTime) {
        this.currentTime = currentTime;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}
