/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.guard.cron;

import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.fileCache.FileCacheItem;
import com.openexchange.guard.database.fileCache.FileCacheStorage;
import com.openexchange.guard.database.fileCache.RestDbFileCacheStorage;
import com.openexchange.guard.database.remoteKeyCache.RemoteKeyCacheStorage;
import com.openexchange.guard.database.remoteKeyCache.RestDbRemoteKeyCacheStorage;
import com.openexchange.guard.storage.Storage;


public class CleanCache extends TimerTask {

	private static Logger logger = LoggerFactory.getLogger(CleanCache.class);

    @Override
    public void run() {
        try {
            logger.info("Running Scheduled cleanup of File Cache");

            //TODO: Using a service locator / DI-Container for resolving
            FileCacheStorage fileCacheStorage = new RestDbFileCacheStorage();

            //Getting unused fileCache items
            List<FileCacheItem> fileCacheItems = fileCacheStorage.findOld(Config.cachedays);
            int failedItems = 0;

            //Remove the unused fileCache items from the storages
            for(FileCacheItem fileCacheItem : fileCacheItems) {
                try {
                    //Remove from the file storage
                    Storage.deleteEncrObj(fileCacheItem.getLocation());
                    //Remove from the persistent storage (usually the DB)
                    fileCacheStorage.delete(fileCacheItem.getItemId());
                } catch (Exception ex) {
                    logger.error("Error delete object ", ex);
                    failedItems++;
                }
            }
            logger.info("Deleted " + fileCacheItems.size() + " files");
            if(failedItems > 0) {
                logger.error("Failed deleting " + failedItems + " files");
            }

        } catch (Exception e) {
            logger.error("Error while doing scheduled cleanup of file cache", e);
        }


        try {
            //Cleanup remote key cache (cached HKP Keys)
            logger.info("Running Scheduled cleanup of PGP Cache");
            RemoteKeyCacheStorage remoteKeyCacheStorage = new RestDbRemoteKeyCacheStorage();
            int deletedKeys = remoteKeyCacheStorage.deleteOld(Config.pgpCacheDays);
            if(deletedKeys > 0) {
                logger.info("Deleted " + deletedKeys + " old PGP key rings from remote cache");
            }
        } catch (Exception e) {
            logger.error("Error removing older PGP keys from remote cache", e);
        }
    }

}
