/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ReflectionException;

public class ReflectionUtils {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static boolean isStatic(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("The member must not be null");
        }
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isFinal(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("The member must not be null");
        }
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPublicScope(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("The member must not be null");
        }
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isProtectedScope(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("The member must not be null");
        }
        return Modifier.isProtected(member.getModifiers());
    }

    public static boolean isPackageScope(Member member) {
        return !ReflectionUtils.isPublicScope(member) && !ReflectionUtils.isProtectedScope(member) && !ReflectionUtils.isPrivateScope(member);
    }

    public static boolean isPrivateScope(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("The member must not be null");
        }
        return Modifier.isPrivate(member.getModifiers());
    }

    public static Class getClass(String className) throws ReflectionException {
        if (StringUtils.isEmpty(className)) {
            throw new IllegalArgumentException("The class name must not be null");
        }
        try {
            return Class.forName(className);
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting class", className, null, null), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting class", className, null, null), ex);
        }
    }

    public static boolean isCompatible(Class[] requestedTypes, Class[] paramTypes) {
        if (!ArrayUtils.isSameLength(requestedTypes, paramTypes)) {
            return false;
        }
        if (requestedTypes == null) {
            requestedTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (paramTypes == null) {
            paramTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        int i = 0;
        while (i < requestedTypes.length) {
            if (!ReflectionUtils.isCompatible(requestedTypes[i], paramTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCompatible(Class requestedType, Class parameterType) {
        if (ClassUtils.isAssignable(requestedType, parameterType)) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            if (Boolean.TYPE.equals(parameterType)) {
                return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(requestedType);
            }
            if (Byte.TYPE.equals(parameterType)) {
                return (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requestedType);
            }
            if (Short.TYPE.equals(parameterType)) {
                return (class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(requestedType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requestedType);
            }
            if (Character.TYPE.equals(parameterType)) {
                return (class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(requestedType);
            }
            if (Integer.TYPE.equals(parameterType)) {
                return (class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(requestedType) || (class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(requestedType) || (class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(requestedType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requestedType);
            }
            if (Long.TYPE.equals(parameterType)) {
                return (class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(requestedType) || (class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(requestedType) || (class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(requestedType) || (class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(requestedType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requestedType);
            }
            if (Float.TYPE.equals(parameterType)) {
                return (class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(requestedType) || (class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(requestedType) || (class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(requestedType) || (class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(requestedType) || (class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(requestedType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requestedType);
            }
            if (Double.TYPE.equals(parameterType)) {
                return (class$java$lang$Double == null ? (class$java$lang$Double = ReflectionUtils.class$("java.lang.Double")) : class$java$lang$Double).equals(requestedType) || (class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(requestedType) || (class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(requestedType) || (class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(requestedType) || (class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(requestedType) || (class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(requestedType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requestedType);
            }
        }
        return false;
    }

    public static Class convertPrimitiveClass(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (cls.isPrimitive()) {
            if (Integer.TYPE.equals(cls)) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (Long.TYPE.equals(cls)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (Boolean.TYPE.equals(cls)) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (Double.TYPE.equals(cls)) {
                return class$java$lang$Double == null ? (class$java$lang$Double = ReflectionUtils.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (Float.TYPE.equals(cls)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (Character.TYPE.equals(cls)) {
                return class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (Short.TYPE.equals(cls)) {
                return class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (Byte.TYPE.equals(cls)) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
        }
        return cls;
    }

    public static String getThrowableText(Throwable th, String desc, String className, Class[] types, String memberName) {
        String message = null;
        try {
            throw th;
        }
        catch (NoSuchMethodException ex) {
            message = "the method does not exist";
        }
        catch (NoSuchFieldException ex) {
            message = "the field does not exist";
        }
        catch (ClassNotFoundException ex) {
            message = "the class could not be found in the classpath";
        }
        catch (InvocationTargetException ex) {
            message = "the method threw an exception";
        }
        catch (InstantiationException ex) {
            message = "the class is abstract/interface/array/primitive";
        }
        catch (IllegalAccessException ex) {
            message = "the method was not public/accessible";
        }
        catch (IllegalArgumentException ex) {
            message = "the parameters did not match those expected";
        }
        catch (SecurityException ex) {
            message = "the security manager prevents reflection";
        }
        catch (ExceptionInInitializerError ex) {
            message = "the class initialization for static variables threw an exception";
        }
        catch (ClassCircularityError ex) {
            message = "a circularity has been detected while initializing a class";
        }
        catch (ClassFormatError ex) {
            message = "the class file is malformed or otherwise cannot be interpreted as a class";
        }
        catch (IncompatibleClassChangeError ex) {
            message = "the method references another class that has changed incompatibly since compile time";
        }
        catch (UnsatisfiedLinkError ex) {
            message = "no implementation found for a native method";
        }
        catch (VerifyError ex) {
            message = "the class file contains an internal inconsistency or security problem";
        }
        catch (NoClassDefFoundError ex) {
            message = "the class references another class that was present at compile time but is no longer available";
        }
        catch (LinkageError ex) {
            message = "the class references another class that has changed incompatibly since compile time";
        }
        catch (Throwable ex) {
            message = null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(ClassUtils.getShortClassName(th, ""));
        buf.append(" while ");
        buf.append(desc);
        buf.append(" on Class '");
        buf.append(className);
        buf.append("'");
        if (types != null) {
            buf.append(" for types ");
            buf.append(ArrayUtils.toString(types));
        }
        if (memberName != null) {
            buf.append(" for method '");
            buf.append(memberName);
            buf.append("'");
        }
        if (message != null) {
            buf.append(" - ");
            buf.append(message);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

