/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import org.apache.commons.lang.NumberUtils;

public abstract class Range {
    public abstract Number getMinimumNumber();

    public long getMinimumLong() {
        return this.getMinimumNumber().longValue();
    }

    public int getMinimumInteger() {
        return this.getMinimumNumber().intValue();
    }

    public double getMinimumDouble() {
        return this.getMinimumNumber().doubleValue();
    }

    public float getMinimumFloat() {
        return this.getMinimumNumber().floatValue();
    }

    public abstract Number getMaximumNumber();

    public long getMaximumLong() {
        return this.getMaximumNumber().longValue();
    }

    public int getMaximumInteger() {
        return this.getMaximumNumber().intValue();
    }

    public double getMaximumDouble() {
        return this.getMaximumNumber().doubleValue();
    }

    public float getMaximumFloat() {
        return this.getMaximumNumber().floatValue();
    }

    public abstract boolean includesNumber(Number var1);

    public boolean includesLong(Number value) {
        if (value == null) {
            return false;
        }
        return this.includesLong(value.longValue());
    }

    public boolean includesLong(long value) {
        return value >= this.getMinimumLong() && value <= this.getMaximumLong();
    }

    public boolean includesInteger(Number value) {
        if (value == null) {
            return false;
        }
        return this.includesInteger(value.intValue());
    }

    public boolean includesInteger(int value) {
        return value >= this.getMinimumInteger() && value <= this.getMaximumInteger();
    }

    public boolean includesDouble(Number value) {
        if (value == null) {
            return false;
        }
        return this.includesDouble(value.doubleValue());
    }

    public boolean includesDouble(double value) {
        int compareMin = NumberUtils.compare(this.getMinimumDouble(), value);
        int compareMax = NumberUtils.compare(this.getMaximumDouble(), value);
        return compareMin <= 0 && compareMax >= 0;
    }

    public boolean includesFloat(Number value) {
        if (value == null) {
            return false;
        }
        return this.includesFloat(value.floatValue());
    }

    public boolean includesFloat(float value) {
        int compareMin = NumberUtils.compare(this.getMinimumFloat(), value);
        int compareMax = NumberUtils.compare(this.getMaximumFloat(), value);
        return compareMin <= 0 && compareMax >= 0;
    }

    public boolean includesRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.includesNumber(range.getMinimumNumber()) && this.includesNumber(range.getMaximumNumber());
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.includesNumber(this.getMinimumNumber()) || range.includesNumber(this.getMaximumNumber()) || this.includesNumber(range.getMinimumNumber());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range range = (Range)obj;
        return this.getMinimumNumber().equals(range.getMinimumNumber()) && this.getMaximumNumber().equals(range.getMaximumNumber());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + this.getMinimumNumber().hashCode();
        result = 37 * result + this.getMaximumNumber().hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append("Range[");
        buf.append(this.getMinimumNumber());
        buf.append(',');
        buf.append(this.getMaximumNumber());
        buf.append(']');
        return buf.toString();
    }
}

