/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.NotifierException;

public class Notifier {
    private ArrayList listeners = new ArrayList();
    private Method listenerMethod;
    private String methodName;
    private Class clss;
    static /* synthetic */ Class class$java$util$EventObject;

    public Notifier(Class listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Illegal to have a null listener Class. ");
        }
        this.clss = listener;
        Method[] meths = this.clss.getDeclaredMethods();
        if (meths.length == 0) {
            this.listenerMethod = meths[0];
        }
    }

    public Notifier(Class clss, String name) {
        if (clss == null) {
            throw new IllegalArgumentException("Illegal to have a null Listener Class. ");
        }
        if (name == null) {
            throw new IllegalArgumentException("Illegal to have a null method name. ");
        }
        this.clss = clss;
        this.methodName = name;
        try {
            this.listenerMethod = this.clss.getDeclaredMethod(name, class$java$util$EventObject == null ? (class$java$util$EventObject = Notifier.class$("java.util.EventObject")) : class$java$util$EventObject);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Method not on Class. ");
        }
    }

    public void addListener(Object not) {
        this.listeners.add(not);
    }

    public void removeListener(Object not) {
        ((AbstractCollection)this.listeners).remove(not);
    }

    public List getListeners() {
        ArrayList cloned = new ArrayList(this.listeners);
        return Collections.unmodifiableList(cloned);
    }

    public void notify(EventObject event) throws NotifierException {
        if (this.clss == null) {
            this.notify(this.methodName, event);
        } else {
            this.notify(this.listenerMethod, event);
        }
    }

    private void notify(Method listenerMethod, EventObject event) throws NotifierException {
        Iterator itr = this.getListeners().iterator();
        while (itr.hasNext()) {
            try {
                Object listener = itr.next();
                listenerMethod.invoke(listener, event);
            }
            catch (SecurityException se) {
                throw new NotifierException(se);
            }
            catch (IllegalAccessException iae) {
                throw new NotifierException(iae);
            }
            catch (IllegalArgumentException iae) {
                throw new NotifierException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new NotifierException(ite);
            }
        }
    }

    public void notify(String methodName, EventObject event) throws NotifierException {
        Iterator itr = this.getListeners().iterator();
        while (itr.hasNext()) {
            try {
                Object listener = itr.next();
                Class<?> clss = listener.getClass();
                Method method = clss.getMethod(methodName, event.getClass());
                method.invoke(listener, event);
            }
            catch (SecurityException se) {
                throw new NotifierException(se);
            }
            catch (NoSuchMethodException nsme) {
                throw new NotifierException(nsme);
            }
            catch (IllegalAccessException iae) {
                throw new NotifierException(iae);
            }
            catch (IllegalArgumentException iae) {
                throw new NotifierException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new NotifierException(ite);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

