Name:             open-xchange-guard
BuildArch:        noarch
#!BuildIgnore:    post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires:    ant
%else
BuildRequires:    ant-nodeps
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires:    java7-devel
%else
BuildRequires:    java-devel >= 1.7.0
%endif
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
BuildRequires:    systemd-rpm-macros
%endif
Version:          2.2.0
%define           ox_release 6
Release:          %{ox_release}_<CI_CNT>.<B_CNT>
Group:            Applications/Productivity
License:          GPL-2.0
BuildRoot:        %{_tmppath}/%{name}-%{version}-build
URL:              http://www.open-xchange.com/
Source:           %{name}_%{version}.orig.tar.bz2
Source1:          open-xchange-guard.init
Source2:          open-xchange-guard.service
Summary:          Open-Xchange Guard micro service
Requires:         jre >= 1.7.0
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd
%endif
%if 0%{?fedora_version} || 0%{?rhel_version}
Requires:         redhat-lsb
%endif

%description
Guard - the Open-Xchange security solution. This package contains the Guard backend component.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/guard
mkdir -p %{buildroot}/var/spool/open-xchange/guard/uploads
mkdir -p %{buildroot}%{_sbindir}
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-guard.service
ln -sf /usr/sbin/service %{buildroot}%{_sbindir}/rcopen-xchange-guard
%else
mkdir -p %{buildroot}/etc/init.d
install -m 755 %{SOURCE1} %{buildroot}/etc/init.d/open-xchange-guard
ln -sf /etc/init.d/open-xchange-guard %{buildroot}%{_sbindir}/rcopen-xchange-guard
%endif

%post
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_add_post open-xchange-guard.service
%endif
if [ ${1:-0} -eq 2 ]; then
    # only when updating
    . /opt/open-xchange/guard/sbin/oxfunctions.sh

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # SoftwareChange_Request-2182
    # -----------------------------------------------------------------------
    pfile=/opt/open-xchange/guard/etc/guard.properties
    if ox_exists_property com.openexchange.guard.logType $pfile; then
        ox_remove_property com.openexchange.guard.logType $pfile
    fi

    # SoftwareChange_Request-2183
    # -----------------------------------------------------------------------
	prefix="com.openexchange.guard."
    declare -a props
    declare -a propKeys=('SSLPort' 'SSLKeyStore' 'SSLKeyName' 'SSLKeyPass');
    declare -a defaults=('8443' '//keystore location//' '//alias name here//' '//ssl password//');

    prop="com.openexchange.guard.useSSL"
    if ox_exists_property $prop $pfile; then
        useSSL=$(ox_read_property $prop $pfile)
    else
        ox_comment $prop remove $pfile
    fi

    for prop in ${propKeys[@]}; do
        p=$prefix$prop
        if ox_exists_property $p $pfile; then
            VALUE=$(ox_read_property $p $pfile)
            props=("${props[@]}" "$VALUE")
        else
            ox_comment $p remove $pfile
        fi
        ox_remove_property $p $pfile
    done

    sed -i 's/com.openexchange.guard.useSSL:.*/# com.openexchange.backend_SSL=true/g' $pfile

    prop="com.openexchange.guard.useSSL"
    commented=false
    if [[ -z "$useSSL" ]]; then
        useSSL="true"
        commented=""
    fi
    ox_set_property $prop "$useSSL" $pfile
    if [[ -z "$commented" ]]; then
        ox_comment $prop add $pfile
    fi

    index=0;
    for prop in ${propKeys[@]}; do
        p=$prefix$prop
        commented=false
        value=${props[$index]}
        if [[ -z "$value" ]]; then
            value=${defaults[$index]}
            commented=""
        fi
        ox_set_property $p "$value" $pfile
        if [[ -z "$commented" ]]; then
            ox_comment $p add $pfile
        fi
        ((index++))
    done
fi

%pre
/usr/sbin/groupadd -r open-xchange 2> /dev/null || :
/usr/sbin/useradd -r -g open-xchange -r -s /bin/false -c "open-xchange system user" -d /opt/open-xchange open-xchange 2> /dev/null || :

%preun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_preun open-xchange-guard.service
%endif

%postun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_postun open-xchange-guard.service
%endif

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
/opt/open-xchange/guard/*
%config(noreplace) %attr(640, root, open-xchange) /opt/open-xchange/guard/etc/*
%dir %attr(750, open-xchange, root) /var/log/open-xchange/guard
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/guard/uploads
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
/usr/lib/systemd/system/open-xchange-guard.service
%{_sbindir}/rcopen-xchange-guard
%else
/etc/init.d/open-xchange-guard
%{_sbindir}/rcopen-xchange-guard
%endif

%changelog
* Mon Oct 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate release for 2.2.0
* Sun Sep 27 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate release for 2.2.0
* Mon Sep 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate release 2.2.0
* Mon Sep 14 2015 Greg Hill <greg.hill@open-xchange.com>
Build for patch 2015-09-24 (2756)
* Mon Sep 14 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate release 2.2.0
* Mon Aug 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.2.0 release
* Mon Aug 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.2.0 release
* Mon Aug 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.2.0 release
* Wed Jul 29 2015 Greg Hill <greg.hill@open-xchange.com>
Build for patch 2015-07-27 (2626)
* Wed Jul 08 2015 Greg Hill <greg.hill@open-xchange.com>
Build for patch 2015-07-09 (2612)
* Tue Jun 30 2015 Greg Hill <greg.hill@open-xchange.com>
Final release candidate for Guard 2.0
* Mon Jun 29 2015 Greg Hill <greg.hill@open-xchange.com>
Fifth candidate for 2.0
* Sun Jun 28 2015 Greg Hill <greg.hill@open-xchange.com>
Fourth candidate for 2.0 release
* Sun Jun 21 2015 Greg Hill <greg.hill@open-xchange.com>
Third candidate for 2.0 release
* Sun Jun 14 2015 Greg Hill <greg.hill@open-xchange.com>
Second candidate for 2.0 release
* Sun Jun 07 2015 Greg Hill <greg.hill@open-xchange.com>
First candidate for 2.0 release
* Mon Feb 09 2015 Greg Hill <greg.hill@open-xchange.com>
prepare for 2.0.0 release
* Sun Jan 04 2015 Greg Hill <greg.hill@open-xchange.com>
Third candidate for 1.2.0 release
* Wed Dec 10 2014 Greg Hill <greg.hill@open-xchange.com>
Second candidate for 1.2.0 release
* Thu Oct 30 2014 Greg Hill <greg.hill@open-xchange.com>
Build for 1.2
* Fri Oct 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-09
* Wed Sep 03 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 1.0.0 release
* Tue Sep 02 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 1.0.0 release
* Thu Aug 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 1.0.0 release
* Thu Aug 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 1.0.0
