package com.openexchange.guard.ox.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * A mock encryption handler which does no encryption at all. Useful for testing purpose.
 *
 * @author Benjamin Gruedelbach
 */
public class MockStreamEncryptionHandler implements StreamHandler{

	@Override
    public void processStream(InputStream inputStream,
        OutputStream outputStream,
        int suggestedBufferSize) throws IOException {

        boolean reading = true;
        while (reading) {
            //Reading the input stream
            byte[] buffer = new byte[suggestedBufferSize];
            int bytesRead = inputStream.read(buffer);
            reading = bytesRead > 0;
            if (reading) {
                //just write the bytes to the output stream and
                outputStream.write(buffer, 0, bytesRead);
            }
        }
	}

    @Override
    public String getNewContentType(String oldContentType, String fileName) {
        return oldContentType;
    }

    @Override
    public String getNewName(String oldName) {
        return oldName;
    }
}
