package com.openexchange.guard.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.mailcreator.Attachment;
import ch.qos.logback.classic.Logger;

public class MimeParser {

    private static Logger logger = (Logger) LoggerFactory.getLogger(MimeParser.class);

	ArrayList<Attachment> attachments = new ArrayList<Attachment> ();
	MimeMessage message;

	MimeParser (byte[] email) throws MessagingException {
		Session s = Session.getDefaultInstance(new Properties());
    	InputStream is = new ByteArrayInputStream(email);
    	message = new MimeMessage(s, is);
	}

	public MimeMessage getMessage() {
	    return(message);
	}

	public MimeMultipart getFirstMultipart() throws IOException, MessagingException {
	    Object content = message.getContent();
        if (content instanceof Multipart || content instanceof MimeMultipart)  {
            MimeMultipart mp = (MimeMultipart)content;
            return (mp);
        }
        return (null);
	}

	public void ParseAttachments () throws MessagingException, IOException {
		Object content = message.getContent();
	    if (content instanceof Multipart || content instanceof MimeMultipart)  {
	    	Multipart mp = (Multipart)content;
	    	parseMultipart (mp);
	    }
	}

	public void parseMultipart(Multipart mp) throws IOException, MessagingException
	{
	    int count = mp.getCount();
	    for (int i = 0; i < count; i++)
	    {
	        BodyPart bp = mp.getBodyPart(i);
	        Object content = bp.getContent();
	        if (content instanceof String)
	        {  // Check if this string is a text attachment, or just the message body
	        	if (bp.getDisposition() != null) {
	        		if (bp.getDisposition().contains("attachment")) {
	        			Attachment att = new Attachment();
	    	        	att.content = ((String) content).getBytes("UTF-8");
	    	        	att.filename = bp.getFileName();
	    	        	att.type = bp.getContentType();
	    	        	if (att.type.contains(";")) {
	    	        		att.type = att.type.substring(0, att.type.indexOf(";"));
	    	        	}
	    	        	attachments.add(att);
	        		}
	        	}

	        }
	        else if (content instanceof InputStream)
	        {

	        	Attachment att = new Attachment();
	        	att.content = IOUtils.toByteArray((InputStream) content);
	        	att.filename = bp.getFileName();
	        	att.type = bp.getContentType();
	        	if (att.type.contains(";")) {
	        		att.type = att.type.substring(0, att.type.indexOf(";"));
	        	}
	        	attachments.add(att);
	            // handle input stream
	        }
	        else if (content instanceof Message)
	        {
	            Message message = (Message)content;
	            // Nested message
	        }
	        else if (content instanceof Multipart || content instanceof MimeMultipart)
	        {
	            Multipart mp2 = (Multipart)content;
	            parseMultipart(mp2);
	        }
	    }
	}

	public void mergeAttachments (ArrayList<Attachment> prevattachments) {
		for (int i = 0; i < attachments.size(); i++) {
			prevattachments.add(attachments.get(i));
		}
	}

	public static String decodeMimePart (MimePart mp) throws IOException, MessagingException {
	    ByteArrayOutputStream writer = new ByteArrayOutputStream();
        mp.writeTo(writer);
        String section = writer.toString("UTF-8");
        MimePartDataSource ds = new MimePartDataSource (mp);
        ByteArrayOutputStream decoded = new ByteArrayOutputStream();
        IOUtils.copy(ds.getInputStream(), decoded);
        int i = section.indexOf("\r\n\r\n");
        if (i > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(section.substring(0, i));
            sb.append("\r\n\r\n");
            sb.append(decoded.toString("UTF-8"));
            return (sb.toString());
        }
        return (decoded.toString("UTF-8"));
	}

	/**
	 * Get the first MIME boundry/border in a mime message
	 * @param msg
	 * @return null if no boarder specified in content-type
	 * @throws MessagingException
	 */
	public static String getBoundry (MimeMessage msg) throws MessagingException {
	    try {
    	    String [] content = msg.getHeader("Content-Type");
    	    if (content.length > 0) {
    	        int i = content[0].indexOf("boundary");
    	        if (i > 0) {
    	            String bndry = content[0].substring(i);
    	            if (bndry.contains(";")) bndry = bndry.substring(0, bndry.indexOf(";"));
    	            return (bndry.substring(bndry.indexOf("\"")).replace("\"", ""));
    	        }
    	    }
	    } catch (Exception e) {
	        logger.error("Error finding mime border ", e);
	    }
	    return (null);
	}

	/**
	 * Function to parse out first section of mime body using the border
	 * @param mime The mime body
	 * @param border The mime section border
	 * @return
	 */
	public static String getMimeSection (String mime, String border) {
	    if (border == null) return (mime);
	    try {
	        border = "--" + border;
	        int j = mime.indexOf(border);
	        int k = mime.indexOf(border, j + 10);
	        if (j > 0 && k > 0) {
	            String data = mime.substring(j + 2 + border.length(), k - 2);
	            return (data);
	        }
	    } catch (Exception e) {
	        logger.error("Error parsing mime section for email");
	    }

	    return (mime);
	}
}
