package com.openexchange.guard.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.JsonObject;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.encr.Crypto;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.EncryptedObj;
import com.openexchange.guard.exceptions.BadRSAException;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.logging.LogAction;
import com.openexchange.guard.mailcreator.Attachment;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.server.OxCookie;
import com.openexchange.guard.server.UserData;
import com.openexchange.guard.util.Core;

public class Attachments {

	private static Logger logger = LoggerFactory.getLogger(Attachments.class);

    OxCookie cookie;

    public Attachments(OxCookie ck) {
        cookie = ck;
    }

	   /**
     * Function to return encrypted attachment (non email)
     *
     * @param request
     * @param response
     * @param cookie
     * @throws IOException
	 * @throws GuardMissingParameter
     */
    public void getEncrAttach(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws IOException, GuardMissingParameter {
    	String emailid = Core.getStringParameter(request, "emailid", true);
    	String folder = Core.getStringParameter(request, "folder", true);
        int userid = Core.getIntParameter(request, "userid", true);
        int attachid = Core.getIntParameter(request, "attach", true);
        int cid = Core.getIntParameter(request, "cid", true);
        LogAction.setUser(userid, cid);
        String auth = Core.getStringParameter(request, "auth");
        if (auth == null) auth = "";
        String filename = Core.getStringParameter(request, "attname", true);
        String sessionID = Core.getStringParameter(request, "session");
        String extrapass = Core.getStringParameter(request, "extrapass");
        String encrextrapass = Core.getStringParameter(request, "encrextrapass");
        String download = Core.getStringParameter(request, "download");
        String cc = Core.getStringParameter(request, "cc");  // Content key if decoded offsite ---- Future, not currently implemented
        UserData data;
        if (auth.length() < 20) {
            String password = Core.getStringParameter(request, "password");
            if ((password == null) || password.equals("undefined")) {
                String epassword = Core.getStringParameter(request, "epassword");
                if (epassword != null) {
                    Access acc = new Access();
                    String token = acc.getToken(cookie.JSESSIONID);
                    EncrLib enc = new EncrLib();
                    password = enc.decryptAES(epassword, token);
                }
            }
            data = new UserData();
            data.encr_password = password;
            data.userid = userid;
        } else {
            data = new UserData(auth, cookie);
        }
        com.openexchange.guard.encr.DecodedObj decoded = decodeAttach(
            request,
            response,
            emailid,
            userid,
            attachid,
            cid,
            auth,
            filename,
            sessionID,
            extrapass,
            encrextrapass,
            folder,
            cc,
            data);
        if (decoded == null) {
        	logger.debug("Failed to decode attachment");
            com.openexchange.guard.util.Core.sendFail(response, "Failed to decode");
            return;
        }
        if (decoded.decoded64 == "exp") { // If our email has expired, then just send that
        	logger.info("Expired attachment");
            com.openexchange.guard.util.Core.sendOK(response, "Attachment Expired");
            return;
        }
        logger.info("Success decode attachment");
        if ((download != null) && download.contains("true")) { // Send the attachment to broswer to save
            sendToSaveAttach(response, decoded.type, Base64.decode(decoded.decoded64), filename);
        } else {
            try {
                com.openexchange.guard.util.Core.sendOK(response, decoded.type, Base64.decode(decoded.decoded64));
            } catch (Exception ex) {
                logger.error("Error sending OK response", ex);
                com.openexchange.guard.util.Core.sendFail(response, "Error");
            }
        }

    }

    public void saveDecodedAttach(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) throws IOException, GuardMissingParameter, BadRSAException {
        JsonObject json = com.openexchange.guard.util.Core.getJSON(request);
        String folder = Core.getStringFromJson(json, "folder", true);
        String emailid = json.get("id").getAsString();
        int userid = Core.getIntFromJson(json, "userid", true);
        int attachid = Core.getIntFromJson(json, "attachment", true);
        int cid = Core.getIntFromJson(json, "cid", true);
        String auth = json.get("auth").isJsonNull() ? "" : json.get("auth").getAsString();
        String filename = Core.getStringFromJson(json, "filename", true);
        String sessionID = Core.getStringFromJson(json, "session_id", true);
        String description = Core.getStringFromJson(json, "description");
        String dest_folder = Core.getStringFromJson(json, "dest_folder", true);
        String cc = Core.getStringFromJson(json, "cc");
        String extrapass = Core.getStringFromJson(json, "extrapass");
        String encrextrapass = "";
        if (json.get("encrextrapass") != null) {
            encrextrapass = json.get("encrextrapass").getAsString();
        }
        UserData data;
        if (auth.length() < 20) {
            String password = request.getParameter("password");
            if ((password == null) || password.equals("undefined")) {
                String epassword = json.get("epassword").getAsString();
                if (epassword != null) {
                    Access acc = new Access();
                    String token = acc.getToken(cookie.JSESSIONID);
                    EncrLib enc = new EncrLib();
                    password = enc.decryptAES(epassword, token);
                } else password = null; // null password if was undefined and no epassword
            }
            data = new UserData();
            data.encr_password = password;
            data.userid = userid;
        } else {
            data = new UserData(auth, cookie);
        }
        if (data.encr_password == null) {
            com.openexchange.guard.util.Core.sendFail(response, "Failed to decode");
            return;
        }
        com.openexchange.guard.encr.DecodedObj decoded = decodeAttach(
            request,
            response,
            emailid,
            userid,
            attachid,
            cid,
            auth,
            filename,
            sessionID,
            extrapass,
            encrextrapass,
            folder,
            cc,
            data);
        if (decoded == null) {
            com.openexchange.guard.util.Core.sendFail(response, "Failed to decode");
            return;
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment file = new Attachment();
        file.content = Base64.decode(decoded.decoded64);
        file.filename = filename;
        file.type = decoded.type;
        attachments.add(file);

        // Save to ox backend
        String params = "files?action=new&filename=" + URLEncoder.encode(filename) + "&session=" + sessionID;
        com.openexchange.guard.ox.Api ap = new com.openexchange.guard.ox.Api(cookie, request);
        String newjson = "{\"folder_id\" : \"" + dest_folder + "\",\"description\":\"" + description + "\"}";
        String resp = ap.filePost(newjson, params, attachments);
        if (com.openexchange.guard.util.Core.checkFail(resp)) {
        	String error = Core.getError(resp);
            com.openexchange.guard.util.Core.sendFail(response, (error.equals("") ? "Failed to save" : error));
        } else {
            com.openexchange.guard.util.Core.sendOK(response, "OK");
        }
    }

    /*
     * Decodes an encrypted attachment and returns to decoded
     */
    public com.openexchange.guard.encr.DecodedObj decodeAttach(HttpServletRequest request, HttpServletResponse response, String emailid, int userid, int attachid, int cid, String auth, String filename, String sessionID, String extrapass, String encrextrapass, String folder, String cc, UserData data) {

        if (data.userid == -1) {
            com.openexchange.guard.util.Core.sendFail(response, "Bad authorization");
            return (null);
        }
        Crypto crypto = new Crypto();
        try {
            Api ap = new Api(cookie, sessionID, request.getHeader("User-Agent"));
            EncryptedObj attdata = ap.getAttachment(emailid, attachid, folder);
            com.openexchange.guard.encr.DecodedObj decoded = new com.openexchange.guard.encr.DecodedObj();
            decoded.type = attdata.content_type.replace("grd/","").replace("--","/");// save content type
            decoded.decoded64 = crypto.decodeEncrObj(userid, cid, attdata, data.encr_password, cc);
            if (decoded.decoded64 != null) {// Data was stored base64, so we need to decode when returned
                EncrLib encr = new EncrLib();
                if (extrapass == null) {// If plaintext extrapass is null, then look at encryptedpass
                    if (encrextrapass != null) {
                        if (!encrextrapass.equals("")) {
                            Access acc = new Access();
                            String token = acc.getToken(cookie.JSESSIONID);
                            extrapass = encr.decryptAES(encrextrapass, token);
                        }
                    }
                }
                if (extrapass != null) {
                    if (!extrapass.equals("")) {
                        decoded.decoded64 = encr.decryptAES(decoded.decoded64.substring(5), extrapass, attdata.ItemID, attdata.keyLength);
                    }
                }

                return (decoded);
            }
        } catch (Exception e) {
            logger.error("Error decoding attachment " + attachid + " of email " + emailid, e);
        }
        if (response != null) com.openexchange.guard.util.Core.sendFail(response, "Unable to decrypt");
        return (null);
    }







    /**
     * Send attachment contents to browser with flags to save to disk
     *
     * @param response
     * @param type
     * @param answer
     * @param filename
     */
    private void sendToSaveAttach(HttpServletResponse response, String type, byte[] answer, String filename) {
        response.setContentType(type);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setStatus(HttpServletResponse.SC_OK);
        try {
            OutputStream out = response.getOutputStream();
            out.write(answer);
            out.close();
        } catch (IOException e) {
        	logger.error("Error when writing to output stream", e);
        }
    }
}
