/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.encr;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;

public class EncrLib {
	private static Logger logger = LoggerFactory.getLogger(EncrLib.class);
    /**
     * Encrypt String and return base64 encrypted string
     *
     * @param data string to encrypt
     * @param Password
     * @param Salt
     * @return encrypted base64 string
     */

    static final String passChars = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjklmnpqrstuvwxyz"; // Characters for random password.
                                                                                                  // Excluding O and I for now

    public String encryptAES(String data, String Password, String Salt, int keylen) {
        try {
            SecretKey secretKey = getKey(Password, Salt, keylen);
            return (encryptAES(data, secretKey));
        } catch (Exception e) {
            logger.error("Error encrypting", e);
            return ("");
        }
    }

    private String encryptAES(String data, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "BC");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            AlgorithmParameters parameters = cipher.getParameters();
            byte[] iv = parameters.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] ciphertext = cipher.doFinal(data.getBytes("UTF-8"));
            String encrypted = Base64.encodeBase64String(ciphertext);;
            String iVString = Base64.encodeBase64String(iv);
            String combo = iVString + encrypted;
            return (combo);
        } catch (Exception e) {
            logger.error("Error encrypting", e);
            return ("");
        }
    }

    public String encryptAES(String data, String base64Key) {
        SecretKey secretkey = new SecretKeySpec(Base64.decodeBase64(base64Key), "AES");
        return (encryptAES(data, secretkey));
    }

    public String decryptAES(String data, String Password, String Salt, int keylen) {
        return (decryptAES(data, Password, Salt, keylen, true));
    }

    /**
     * Decrypt a base64 string
     *
     * @param data base64 string to decrypt
     * @param Password
     * @param Salt
     * @param keylen
     * @param logBad
     * @return Plaintext string
     */
    public String decryptAES(String data, String Password, String Salt, int keylen, boolean logbad) {
        try {
            SecretKey secretKey = getKey(Password, Salt, keylen);
            return (decryptAES(data, secretKey, logbad));
        } catch (Exception e) {
            if (logbad) {
                logger.info("Bad Pass");
            }
        }
        return ("");
    }

    public String decryptAES(String data, String base64Key) {
        SecretKey secretkey = new SecretKeySpec(Base64.decodeBase64(base64Key), "AES");
        return (decryptAES(data, secretkey, true));
    }

    private String decryptAES(String data, SecretKey secretKey, boolean logbad) {
        try {
            Cipher ciper = Cipher.getInstance("AES/CBC/PKCS5Padding", "BC");
            byte[] iv64 = data.substring(0, 24).getBytes("UTF-8");
            byte[] iv = Base64.decodeBase64(iv64);
            data = data.substring(24);
            byte[] databytes = Base64.decodeBase64(data);
            ciper.init(Cipher.DECRYPT_MODE, secretKey, new IvParameterSpec(iv));
            String plaintext = new String(ciper.doFinal(databytes), "UTF-8");
            return (plaintext);
        } catch (Exception e) {
            if (logbad) {
                logger.info(e.getMessage());
            }
        }
        return ("");
    }

    /**
     * Function to generate random salt
     *
     * @return string of random salt
     */
    public static String getsalt() {
        Random random = new SecureRandom();
        byte[] salt = new byte[20];
        random.nextBytes(salt);
        return (Base64.encodeBase64String(salt));
    }

    /**
     * Generate a random SecretKey
     *
     * @return
     * @throws NoSuchProviderException
     * @throws NoSuchAlgorithmException
     */
    public static SecretKey genRandomKey() throws NoSuchAlgorithmException, NoSuchProviderException {

        KeyGenerator keyGen = KeyGenerator.getInstance("AES", "BC");
        keyGen.init(Config.AESKeyLen);
        return (keyGen.generateKey());
    }

    public static String genRandom64Key() {
        try {
            return (Base64.encodeBase64String(genRandomKey().getEncoded()));
        } catch (Exception ex) {
            logger.error("Failure while getting random key", ex);
            return ("");
        }
    }

    /**
     * Generate key from password and salt
     *
     * @param Password
     * @param Salt
     * @return SecretKey
     */
    private SecretKey getKey(String Password, String Salt, int keylen) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1", "BC");
            KeySpec spec = new PBEKeySpec(Password.toCharArray(), Salt.getBytes("UTF-8"), 5000, keylen);
            SecretKey tmpKey = factory.generateSecret(spec);
            SecretKey secretKey = new SecretKeySpec(tmpKey.getEncoded(), "AES");
            return (secretKey);
        } catch (Exception e) {
            logger.info("Bad Pass Keygen", e);
            return (null);
        }
    }

    public BigInteger[] generateRSAkey() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kpair = kpg.genKeyPair();
        KeyFactory factory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec pub = factory.getKeySpec(kpair.getPublic(), RSAPublicKeySpec.class);
        RSAPrivateKeySpec priv = factory.getKeySpec(kpair.getPrivate(), RSAPrivateKeySpec.class);
        BigInteger[] keys = { priv.getPrivateExponent(), priv.getModulus(), pub.getPublicExponent(), pub.getModulus() };
        return (keys);
    }

    public String encryptRSA(String text, PublicKey key) {
        byte[] cipherText = null;
        try {
            // get an RSA cipher object
            final Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
            // encrypt the plain text using the public key
            cipher.init(Cipher.ENCRYPT_MODE, key);
            cipherText = cipher.doFinal(text.getBytes("UTF-8"));
        } catch (Exception e) {
            logger.error("Error RSA encrypt", e);
        }
        return (Base64.encodeBase64String(cipherText));
    }

    public String encryptRSA(String text, PrivateKey key) {
        byte[] cipherText = null;
        try {
            // get an RSA cipher object and print the provider
            final Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
            // encrypt the plain text using the public key
            cipher.init(Cipher.ENCRYPT_MODE, key);
            cipherText = cipher.doFinal(text.getBytes("UTF-8"));
        } catch (Exception e) {
            logger.error("Error RSA encrypt", e);
        }
        return (Base64.encodeBase64String(cipherText));

    }

    public String decryptRSA(String enctext, PrivateKey key) {
        if (key == null)
         {
            return (null); // Passed bad private key
        }
        byte[] text = Base64.decodeBase64(enctext);
        byte[] dectyptedText = null;
        try {
            // get an RSA cipher object and print the provider
            final Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");

            // decrypt the text using the private key
            cipher.init(Cipher.DECRYPT_MODE, key);
            dectyptedText = cipher.doFinal(text);

        } catch (Exception ex) {
            logger.error("Problem decoding RSA", ex);
            return(null);
        }

        return new String(dectyptedText);
    }

    public String decryptRSA(String enctext, PublicKey key) {
        if (key == null)
         {
            return (null); // Passed bad private key
        }
        byte[] text = Base64.decodeBase64(enctext);
        byte[] dectyptedText = null;
        try {
            // get an RSA cipher object and print the provider
            final Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");

            // decrypt the text using the private key
            cipher.init(Cipher.DECRYPT_MODE, key);
            dectyptedText = cipher.doFinal(text);

        } catch (Exception ex) {
            logger.error("Problemd decoding RSA ", ex);
            return(null);
        }

        return new String(dectyptedText);
    }

    public static String getUUID() {
        UUID uid = java.util.UUID.randomUUID();
        return (uid.toString());
    }

    public static String randomPass(int len) {
        SecureRandom random = new SecureRandom();
        StringBuilder newpass = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            newpass.append(passChars.charAt(random.nextInt(passChars.length())));
        }
        return (newpass.toString());
    }

    public static String getSHA(String password, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(salt.getBytes("UTF-8"));
            byte[] hashbytes = md.digest(password.getBytes("UTF-8"));
            return (Base64.encodeBase64String(hashbytes));
        } catch (Exception ex) {
            logger.error("Failure creating SHA digest", ex);
            return ("");
        }
    }

}
