package com.openexchange.guard.database.pgpKeys;


/**
 * {@link PGPKeys} represents a mapping from a userId and contextId to a PGP Key id
 */
public class PGPKeys {

    private final long id;
    private final String email;
    private final String hexId;
    private final int contextId;
    private final boolean local;
    private final long keyId;

    /**
     * Initializes a new {@link PGPKeys}.
     * @param id the public key's id
     * @param email the mail
     * @param hexId the public Key's id in hex
     * @param contextId the context id
     * @param local whether the key is marked as local or not
     * @param keyId the key id
     */
    public PGPKeys(long id,
                   String email,
                   String hexId,
                   int contextId,
                   boolean local,
                   long keyId) {
        this.id = id;
        this.email = email;
        this.hexId = hexId;
        this.contextId = contextId;
        this.local = local;
        this.keyId = keyId;
    }

    public long getId() {
        return id;
    }

    public String getEmail() {
        return email;
    }

    public String getHexId() {
        return hexId;
    }

    public int getContextId() {
        return contextId;
    }

    public boolean isLocal() {
        return local;
    }

    public long getKeyId() {
        return keyId;
    }
}
