package com.openexchange.guard.database.ogPGPKeys;

import java.util.List;

/**
 * {@link OGPGPKey} represents an PGP key which has been uploaded by a user
 *
 * Users are able to upload public PGP keys from other external, non OX Guard users, in order to securely interact with them
 */
public class OGPGPKey {

    private int userId;
    private int contextId;
    private String email;
    private List<String> keyIds;
    private String publicPGPAscData;
    private int shareLevel;
    private boolean inline;

    /**
     * Initializes a new {@link OGPGPKey}.
     * @param userId The uploader's user ID
     * @param contextId the uploader's context ID
     * @param email the email related to the key
     * @param keyIds The key IDs related to the key
     * @param publicPGPAscData the key's ASCII armored PGP data
     * @param shareLevel the level of share
     * @param inline whether OX Guard should use PGP inline while using this key, or not
     */
    public OGPGPKey(int userId,
                    int contextId,
                    String email,
                    List<String> keyIds,
                    String publicPGPAscData,
                    int shareLevel,
                    boolean inline) {
        this.userId = userId;
        this.contextId = contextId;
        this.email = email;
        this.keyIds = keyIds;
        this.publicPGPAscData = publicPGPAscData;
        this.shareLevel = shareLevel;
        this.inline = inline;
    }

    /**
     * @return the user's/uploader's Id
     */
    public int getUserId() {
        return userId;
    }

    /**
     * @param userId the user's/uploader's Id
     */
    public void setUserId(int userId) {
        this.userId = userId;
    }

    /**
     * @return the user's/uploader's Id
     */
    public int getContextId() {
        return contextId;
    }

    /**
     * @param contextId the user's/uploader's Id
     */
    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    /**
     * @return The email related to the key
     */
    public String getEmail() {
        return email;
    }

    /**
     *
     * @param email the email related to the key
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * @return the PGP key IDs related to the public key
     */
    public List<String> getKeyIds() {
        return keyIds;
    }

    /**
     * @param keyIds the PGP key IDs related to the public key
     */
    public void setKeyIds(List<String> keyIds) {
        this.keyIds = keyIds;
    }

    /**
     * @return the public key's ASCII armored PGP data
     */
    public String getPublicPGPAscData() {
        return publicPGPAscData;
    }

    /**
     * @param publicPGPAscData the public key's ASCII armored PGP data
     */
    public void setPublicPGPAscData(String publicPGPAscData) {
        this.publicPGPAscData = publicPGPAscData;
    }

    /**
     * @return the key's share level
     */
    public int getShareLevel() {
        return shareLevel;
    }

    /**
     * @param shareLevel the key's new share level
     */
    public void setShareLevel(int shareLevel) {
        this.shareLevel = shareLevel;
    }

    /**
     * The inline mode which should be used for this key
     * @return whether PGP inline should be used while using this key or not
     */
    public boolean isInline() {
        return inline;
    }

    /**
     * The inline mode which should be used for this key
     * @param inline whether PGP inline should be used while using this key or not
     */
    public void setInline(boolean inline) {
        this.inline = inline;
    }
}
