package com.openexchange.guard.database.ogKeyTable;

public class OGKeyTableSql {
    public static final String SELECT_GUARD_DAEMON_KEY_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = -1 AND cid = 0";
    public static final String SELECT_FOR_USER_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = ? AND cid = ? ORDER BY version DESC";
    public static final String SELECT_FOR_USER_BY_KEYID_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = ? AND cid = ? AND keyid = ?";
    public static final String SELECT_FOR_CONTEXT_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE cid = ?";
    public static final String SELECT_FOR_EMAIL_IN_CONTEXT_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE email = ?";
    public static final String SELECT_CURRENT_FOR_USER_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = ? AND cid = ? AND current=1";
    public static final String SELECT_CURRENT_FOR_USER_EMAIL_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE email = ? AND current = 1";;
    public static final String SELECT_HIGHEST_VERSION_KEY_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE cid = ? AND id = ? AND version=(SELECT MAX(version) from og_KeyTable where cid = ? and id = ?)";
    public static final String INSERT_STMT = "INSERT INTO og_KeyTable (id, cid, PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Recovery, Salt, email, lastMod, lang, keyid, version, question, answer, settings, current) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, ?, ?, ?, ?, ?, ?,?)";
    public static final String INSERT_AND_SET_LASTMOD_STMT = "INSERT INTO og_KeyTable (id, cid, PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Recovery, Salt, email, lastMod, lang, keyid, version, question, answer, settings, current) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?, ?, ?, ?, ?,?)";
    public static final String DELETE_KEY_STMT = "DELETE FROM og_KeyTable WHERE cid = ? AND id = ? AND keyid = ?";
    public static final String DELETE_FOR_USER_STMT = "DELETE FROM og_KeyTable WHERE id = ? AND cid = ?";
    public static final String DELETE_FOR_CONTEXT_STMT = "DELETE FROM og_KeyTable WHERE cid = ?";
    public static final String DELETE_RECOVERY_FROM_KEY_STMT = "UPDATE og_KeyTable SET Recovery = '' WHERE id = ? and cid = ?";
    public static final String UPDATE_PGP_PUBLIC_STMT = "UPDATE og_KeyTable SET PGPPublic = ? WHERE keyid = ?";
    public static final String UPDATE_PGP_PUBLIC_AND_PRIVATE_STMT = "UPDATE og_KeyTable Set PGPSecret = ?, PGPPublic = ? WHERE id = ? AND cid = ? AND keyid = ?";
    public static final String UPDATE_QUESTION_STMT = "UPDATE og_KeyTable SET question = ?, answer = ?" + " WHERE id = ? AND cid = ?";
    public static final String UPDATE_PASSWORDS_AND_LASTMOD_STMT = "UPDATE og_KeyTable Set PGPSecret = ?, RSAPrivate = ?, Recovery = ?, lastMod = NOW() WHERE id = ? AND cid = ? AND keyid = ?;";
    public static final String UPDATE_PASSWORDS_STMT = "UPDATE og_KeyTable Set PGPSecret = ?, RSAPrivate = ?, Recovery = ?, lastMod = NULL WHERE id = ? AND cid = ? AND keyid = ?;";
    public static final String UPDATE_DUPLICATED_STMT = "UPDATE og_KeyTable SET RSAPrivate = ?, PGPSecret = ?, PGPPublic = ?, Recovery = ?, Salt = ? WHERE id = ? AND cid = ? and keyid = ?";
    public static final String UPDATE_PIN_STMT = "UPDATE og_KeyTable Set question = 'PIN', answer = ? WHERE id = ? AND cid = ?;";
    public static final String UPDATE_VERSION_STMT = "UPDATE og_KeyTable SET version = 0 WHERE cid = ? AND id = ? AND version = ?";
    public static final String SET_CURRENT_STMT = "UPDATE og_KeyTable SET current = 1 WHERE id = ? and cid = ? and keyid = ?";
    public static final String UNSET_CURRENT_FOR_USER_STMT = "UPDATE og_KeyTable SET current = 0 WHERE id = ? and cid = ?";
    public static final String EXISTS_STMT = "SELECT id FROM og_KeyTable LIMIT 1";
    public static final String ALTER_AUTOINCREMENT_STMT = "ALTER TABLE `og_KeyTable` AUTO_INCREMENT=?";
}
