package com.openexchange.guard.database.ogEmail;

/**
 * Represents a mapping between a user's ID and a user's email
 */
public class OGEmail {

    private final String email;
    private final int userId;
    private final int contextId;
    private final int shardingId;

    /**
     * Constructor
     * @param email The user's email
     * @param userId The user's ID
     * @param contextId The user's context id
     * @param shardingId the shard/database id pointing to the database which
     *                   contains the key data related to this email
     */
    public OGEmail(String email, int userId, int contextId,int shardingId) {
        this.email = email;
        this.userId = userId;
        this.contextId = contextId;
        this.shardingId = shardingId;
    }

    /**
     * Gets the user's email
     * @return the user's email
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * Gets the user's ID
     * @return the user's ID
     */
    public int getUserId() {
        return this.userId;
    }

    /**
     * Gets the user's context ID
     * @return the user's context ID
     */
    public int getContextId() {
        return this.contextId;
    }

    /**
     * The shard ID pointing to the database which contains the key information related to this email
     * @return the shard id
     */
    public int getShardingId() {
        return shardingId;
    }

}
