package com.openexchange.guard.database.bad;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;

/**
 * {@link RestDbBadStorage} is a REST DB implementation for a BadStorage
 */
public class RestDbBadStorage implements BadStorage {

    private static Logger logger = LoggerFactory.getLogger(RestDbBadStorage.class);

    @Override
    public Bad getBad(String id) throws Exception{

        if (id == null || id.isEmpty()) {
            throw new InvalidArgumentException("parameter id is null or empty");
        }

        DbQuery db = new DbQuery();
        try {
            DbCommand com = new DbCommand(BadSql.SELECT_BY_ID_STMT);
            com.addVariables(id);
            db.readOG(com);
            if (db.next()) {
                return new Bad(id,
                               db.rs.getTimestamp("last"),
                               db.rs.getTimestamp("cur"),
                               db.rs.getInt("count"));
            }
            return null;
        } catch (Exception e) {
            logger.error("Error while checking whether ID " + id + " was bad", e);
            throw e;
        }
        finally {
            db.close();
        }
    }

    @Override
    public void addBad(String id) throws Exception {
        if (id == null || id.isEmpty()) {
            throw new InvalidArgumentException("parameter id is null or empty");
        }

        DbQuery db = new DbQuery();
        try {
            DbCommand com = new DbCommand(BadSql.DELETE_BY_TIME_STMT);
            com.addVariables(Config.bad_minute_lock);
            db.writeOxGuard(com);
            com = new DbCommand(BadSql.ADD_STMT);
            com.addVariables(id);
            db.writeOxGuard(com);
        }
        catch(Exception e){
            logger.error("Error while adding ID " + id + " to the bad count", e);
            throw e;
        }
        finally {
            db.close();
        }
    }

    @Override
    public void removeBad(String id) throws Exception {

        if (id == null || id.isEmpty()) {
            throw new InvalidArgumentException("parameter id is null or empty");
        }

        DbQuery db = new DbQuery();
        try {
            DbCommand com = new DbCommand(BadSql.DELETE_BY_ID_STMT);
            com.addVariables(id);
            db.writeOxGuard(com);
        }
        catch(Exception e) {
            logger.error("Error while removing ID " + id + " from the bad count", e);
            throw e;
        }
        finally {
            db.close();
        }
    }
}
