package com.openexchange.guard.database.bad;

/**
 * {@link BadStorage} provides access to stored bad login attempts
 */
public interface BadStorage {

    /**
     * Gets the bad login attempts for a given id/session
     * @param id the session to the get the attempts for
     * @return the bad login attempts for the given id
     * @throws Exception due an error
     */
    public Bad getBad(String id) throws Exception;

    /**
     * Adds a bad login attempt for a given id/session
     * @param id the session to add the bad login attempt for
     * @throws Exception due an error
     */
    public void addBad(String id) throws Exception;

    /**
     * Removes all bad login attempts for a given session
     * @param id the session to remove the bad login attempts for
     * @throws Exception due an error
     */
    public void removeBad(String id) throws Exception;
}
