/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.ogEmail.OGEmail;
import com.openexchange.guard.database.ogEmail.OGEmailStorage;
import com.openexchange.guard.database.ogEmail.RestDbOGEmailStorage;
import com.openexchange.guard.database.ogKeyTable.OGKeyTableStorage;
import com.openexchange.guard.database.ogKeyTable.RestDbOGKeyTableStorage;
import com.openexchange.guard.dbpool.ContextDBConnection;
import com.openexchange.guard.dbpool.Manager;
import com.openexchange.guard.setup.RegisterDb;

public class Sharding {

	private static Logger logger = LoggerFactory.getLogger(Sharding.class);

    private static String mysqlIP = com.openexchange.guard.config.Config.getMysqlIP();// IP address of configdb

    private static String mysqlUsername = com.openexchange.guard.config.Config.getMysqlUsername();

    private static String mysqlPassword = com.openexchange.guard.config.Config.getMysqlPassword();

    private static String OGmysqlIP = com.openexchange.guard.config.Config.getMysqlIPOxGuard();

    public static String database_name(int db) {
        return (Config.getShardBaseName() + db);
    }

    /**
     * Create the tables within a shard
     *
     * @param database
     * @return
     */
    public static boolean createTables(int database, boolean OX) {
        String dbase = database_name(database);
        DbCommand com = new DbCommand(DbStrings.createKeyTable);
        DbQuery db = new DbQuery();
        try {
            if (OX) {
                db.writeToDB(com, database);
            } else {
                db.writeToDb(com, dbase);
                setAutoIncr(database);
            }
        } catch (Exception e) {
            logger.error("Failed to create Key Table in shard " + dbase, e);
            return (false);
        }
        com = new DbCommand(DbStrings.createContentKeyTable);
        try {
            if (OX) {
                db.writeToDB(com, database);
            } else {
                db.writeToDb(com, dbase);
            }
        } catch (Exception e) {
            logger.error("Failed to create Content Key Table in shard " + dbase, e);
            return (false);
        }
        com = new DbCommand(DbStrings.createEncryptedTable);
        try {
            if (OX) {
                db.writeToDB(com, database);
            } else {
                db.writeToDb(com, dbase);
            }
        } catch (Exception e) {
            logger.error("Failed to create Encrypted Object Table in shard " + dbase, e);
            return (false);
        }
        com = new DbCommand(DbStrings.createPGPKeysTable);
        try {
            if (OX) {
                db.writeToDB(com, database);
            } else {
                db.writeToDb(com, dbase);
            }
        } catch (Exception e) {
            logger.error("Failed to create Encrypted Object Table in shard " + dbase, e);
            return (false);
        }
        logger.info("Created tables in " + dbase);
        return (true);
    }

    /**
     * Set auto_increment value of keytable above largest current guest id
     * @param database
     * @throws Exception
     */
    public static void setAutoIncr(int database) throws Exception {

        //TODO: Use a service locator for resolving this
        RestDbOGEmailStorage ogEmailStorage = new RestDbOGEmailStorage();
        OGKeyTableStorage ogKeyTableStorage = new RestDbOGKeyTableStorage();

        int max = ogEmailStorage.getHighestGuestId();
        ogKeyTableStorage.updateAutoIncrementInShard(database_name(database), max+10);
    }

    public static boolean checkTables(int database, boolean OX) {
        //TODO: Use a service locator for resolving this
        OGKeyTableStorage ogKeyTableStorage = new RestDbOGKeyTableStorage();
        boolean exists = false;
        try {
            if(OX) {
                exists = ogKeyTableStorage.exists(database);
            }
            else {
                exists = ogKeyTableStorage.existsInShard(database_name(database));
            }
            if(!exists) {
                if (OX) {
                    logger.info("Tables don't exist for OG Database for cid " + database);
                }
                else {
                    logger.info("Tables don't exist for shard " + database_name(database));
                }
                return createTables(database, OX);
            }
            else {
                return true;
            }
        }
        catch(Exception e) {
            return false;
        }
    }

    // On hold for now.  Trouble with Lock Tables and API
    public static int getNextShard_old() throws Exception {
        int shard = 0;
        String command = "LOCK TABLES sharding WRITE";
        DbCommand com = new DbCommand(command);
        MultiCommand mc = new MultiCommand(com);
        command = "update sharding set current_shard = IF(count >= " + Config.shard_size + ", current_shard + 1, current_shard), count = IF(count >= " + Config.shard_size + ", 0, count + 1);";
        DbCommand com2 = new DbCommand(command);
        mc.add(com2);
        command = "SELECT count, current_shard FROM sharding";
        DbCommand com3 = new DbCommand(command);
        com3.resultSet = true;
        mc.add(com3);
        DbQuery db = new DbQuery();
        db.keepOpen = true;
        db.writeOxGuard(mc);
        try {
            if (db.next()) {
                shard = db.rs.getInt("current_shard");
                int count = db.rs.getInt("count");
                if (count == 0) { // If brand new shard, create it
                    newShard(shard);
                    createTables(shard, false);
                }
            }
        } catch (Exception e) {
            logger.error("Error getting next shard", e);
        }
        command = "UNLOCK TABLES";
        DbCommand com4 = new DbCommand(command);
        db.keepOpen = false;
        db.writeOxGuard(com4);
        db.close();
        return (shard);
    }

    /**
     * Get the next shard number.  Locks tables for singular action
     * @return
     * @throws Exception
     */
    public static int getNextShard() throws Exception {
        int shard = 0;
        ContextDBConnection og = Manager.getOxGuardCon();
        String command = "LOCK TABLES sharding WRITE";
        ResultSet rs = null;
        Statement stm = og.con.createStatement();
        stm.execute(command);
        try {
	        command = "update sharding set current_shard = IF(count >= " + Config.shard_size + ", current_shard + 1, current_shard), count = IF(count >= " + Config.shard_size + ", 0, count + 1);";
	        stm.execute(command);
	        command = "SELECT count, current_shard FROM sharding";
	        rs = stm.executeQuery(command);
	        rs.next();
	        shard = rs.getInt("current_shard");
	        int count = rs.getInt("count");
	        	try {
	                if (count == 0) { // If brand new shard, create it
	                    if (newShard(shard)) {
	                    	createTables(shard, false);
	                    } else {
                            return (0);
                        }
	                }
	        	} catch (Exception ex) {
	        		logger.error("Problem creating shard ", ex);
	        		shard = 0;
	        	}
        } catch (Exception ex) {
        	logger.error("Error getting next shard" , ex);
        }
        if (rs != null) {
            rs.close();
        }
        command = "UNLOCK TABLES";
        stm.execute(command);
        stm.close();
        Manager.closeOG(og);
        return (shard);
    }

    public static int getShard(int id, int cid) throws Exception {
        //TODO: resolve using a DI Container
        OGEmailStorage ogEmailStorage = new RestDbOGEmailStorage();

        List<OGEmail> ogEmails = ogEmailStorage.getById(cid, id);
        if(ogEmails.size() > 0) {
            return ogEmails.get(0).getShardingId();
        }
        return -1;
    }

    public static int getShard(String email) throws Exception {
        //TODO: resolve using a DI Container
        OGEmailStorage ogEmailStorage = new RestDbOGEmailStorage();

        OGEmail ogEmail = ogEmailStorage.getByEmail(email);
        if(ogEmail != null) {
            return ogEmail.getShardingId();
        }
        return -1;
    }

    /**
     * Create new shard database and register with OX backend SHOULD BE REWRITTEN WITH API WHEN
     * AVAILABLE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     *
     * @param shard
     * @return
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws ClassNotFoundException
     * @throws SQLException
     */
    public static boolean newShard(int shard) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        if (Config.ogShardIP == null) {
            Config.ogShardIP = OGmysqlIP;
        }
        String OGmysqlConnectionString = "jdbc:mysql://" + Config.ogShardIP + "/?user=" + mysqlUsername + "&password=" + mysqlPassword;
        String OGShardRead = Config.ogShardReadIP == null ? null : ("jdbc:mysql://" + Config.ogShardReadIP + "/");
        String OgShardWrite = "jdbc:mysql://" + Config.ogShardIP + "/";
        Connection intconn = DriverManager.getConnection(OGmysqlConnectionString);

        // Register database

        String createDatabase = "CREATE DATABASE " + Config.getShardBaseName() + shard + " DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci";

        try {
            mysqlExecute(createDatabase, intconn);
        } catch (Exception ex) {
            logger.error("Unable to create " + Config.getShardBaseName()+ shard + " database", ex);
            return (false);
        }
        Connection configdb = DriverManager.getConnection(Config.getConfigDbConnectionString());
        try {
			RegisterDb.register(configdb, OgShardWrite, OGShardRead, "com.mysql.jdbc.Driver", mysqlUsername, mysqlPassword, Config.getShardBaseName() + shard);
		} catch (Exception e) {
			logger.error("Problem registering new database shard", e);
	        configdb.close();
	        intconn.close();
			return(false);
		}
        configdb.close();
        intconn.close();
        return (true);
    }

    private static void mysqlExecute(String command, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute(command);

    }

}
