/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.guard.database;

import java.io.IOException;
import java.io.StringReader;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.cacheitems.Cache;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.keyCache.KeyCacheStorage;
import com.openexchange.guard.database.keyCache.RestDbKeyCacheStorage;
import com.openexchange.guard.encr.EncrLib;

/**
 * Manage pre-generated Key Pairs
 * Must be synchronized, so no duplicate pairs retrieved
 * @author greg
 *
 */
public class KeyPairGen {

	private static Logger logger = LoggerFactory.getLogger(Cache.class);


	/**
	 * Get a pre-generated key pair
	 * @return
	 * @throws IOException
	 */
	public static synchronized AsymmetricCipherKeyPair getKeyPair() throws IOException {
		String data = "";
		try {
		    //TODO: use a service locator or DI Container to resolve this
		    KeyCacheStorage keyCacheStorage = new RestDbKeyCacheStorage();
		    data =keyCacheStorage.popNext();
		}
		catch (Exception ex) {
		    logger.error("Error getting prepared key pair", ex);
		}

		if (data == null) {
            return (null);
        }

		EncrLib encr = new EncrLib();
		data = encr.decryptAES(data, Config.rpass, "key", Config.AESKeyLen);
		if (data.equals("")) {
			logger.error("Unable to decode pre-compiled keys.  Password file change??");
			return(null);
		}
		StringReader reader = new StringReader(data);
		PEMParser parse = new PEMParser(reader);
		PEMKeyPair kp = (PEMKeyPair) parse.readObject();
		reader.close();
		AsymmetricKeyParameter privKey = PrivateKeyFactory.createKey(kp.getPrivateKeyInfo());
		AsymmetricKeyParameter pubKey = PublicKeyFactory.createKey(kp.getPublicKeyInfo());
		AsymmetricCipherKeyPair kp2 = new AsymmetricCipherKeyPair(pubKey, privKey);
		parse.close();
		reader.close();
		return(kp2);
	}
}
