/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.reflect.ReflectionException;
import org.apache.commons.lang.reflect.ReflectionUtils;

public class ConstructorUtils {
    public static final Constructor[] EMPTY_CONSTRUCTOR_ARRAY = new Constructor[0];

    public static Constructor getConstructor(Class cls, Class[] types) {
        return ConstructorUtils.getConstructor(cls, types, false);
    }

    public static Constructor getConstructor(Class cls, Class[] types, boolean breakScope) {
        block10: {
            if (cls == null) {
                throw new IllegalArgumentException("The class must not be null");
            }
            try {
                ConstructorUtils.getConstructorExact(cls, types, breakScope);
            }
            catch (ReflectionException ex) {
                if (types == null || types.length == 0) {
                    throw ex;
                }
                if (ex.getCause() instanceof NoSuchMethodException) break block10;
                throw ex;
            }
        }
        try {
            Constructor<?>[] cons = cls.getDeclaredConstructors();
            int i = 0;
            while (i < cons.length) {
                if (cons[i].getParameterTypes().length == types.length) {
                    // empty if block
                }
                ++i;
            }
            return null;
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting constructor", cls.getName(), types, null), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting constructor", cls.getName(), types, null), ex);
        }
    }

    public static Constructor getConstructorExact(Class cls, Class[] types) {
        return ConstructorUtils.getConstructorExact(cls, types, false);
    }

    public static Constructor getConstructorExact(Class cls, Class[] types, boolean breakScope) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        try {
            if (breakScope) {
                Constructor con = cls.getDeclaredConstructor(types);
                if (!Modifier.isPublic(con.getModifiers())) {
                    ((AccessibleObject)con).setAccessible(true);
                }
                return con;
            }
            return cls.getConstructor(types);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting constructor", cls.getName(), types, null), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "getting constructor", cls.getName(), types, null), ex);
        }
    }

    public static Object newInstance(Constructor con, Object param) {
        return ConstructorUtils.newInstance(con, new Object[]{param}, false);
    }

    public static Object newInstance(Constructor con, Object[] params) {
        return ConstructorUtils.newInstance(con, params, false);
    }

    public static Object newInstance(Constructor con, Object[] params, boolean breakScope) {
        if (con == null) {
            throw new IllegalArgumentException("The constructor must not be null");
        }
        try {
            if (breakScope && !Modifier.isPublic(con.getModifiers())) {
                ((AccessibleObject)con).setAccessible(true);
            }
            return con.newInstance(params);
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "invoking constructor", con.getDeclaringClass().getName(), con.getParameterTypes(), null), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "invoking constructor", con.getDeclaringClass().getName(), con.getParameterTypes(), null), ex);
        }
    }

    public static Object newInstance(String className) {
        return ConstructorUtils.newInstance(className, false);
    }

    public static Object newInstance(String className, boolean breakScope) {
        Class cls = ReflectionUtils.getClass(className);
        return ConstructorUtils.newInstance(cls, breakScope);
    }

    public static Object newInstance(Class cls) {
        return ConstructorUtils.newInstance(cls, false);
    }

    public static Object newInstance(Class cls, boolean breakScope) {
        if (breakScope) {
            return ConstructorUtils.newInstanceExact(cls, null, null, true);
        }
        if (cls == null) {
            throw new IllegalArgumentException("The constructor must not be null");
        }
        try {
            return cls.newInstance();
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (LinkageError ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "instantiating class", cls.getName(), null, null), ex);
        }
        catch (Exception ex) {
            throw new ReflectionException(ReflectionUtils.getThrowableText(ex, "instantiating class", cls.getName(), null, null), ex);
        }
    }

    public static Object newInstance(Class cls, Class[] types, Object[] params) {
        return ConstructorUtils.newInstance(cls, types, params, false);
    }

    public static Object newInstance(Class cls, Class[] types, Object[] params, boolean breakScope) {
        if (!ArrayUtils.isSameLength(types, params)) {
            throw new IllegalArgumentException("The types and params lengths must be the same");
        }
        Constructor con = ConstructorUtils.getConstructor(cls, types, breakScope);
        return ConstructorUtils.newInstance(con, params, breakScope);
    }

    public static Object newInstanceExact(Class cls, Class[] types, Object[] params) {
        return ConstructorUtils.newInstanceExact(cls, types, params, false);
    }

    public static Object newInstanceExact(Class cls, Class[] types, Object[] params, boolean breakScope) {
        if (!ArrayUtils.isSameLength(types, params)) {
            throw new IllegalArgumentException("The types and params lengths must be the same");
        }
        Constructor con = ConstructorUtils.getConstructorExact(cls, types, breakScope);
        return ConstructorUtils.newInstance(con, params, breakScope);
    }
}

