/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ClassUtils {
    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortClassName(object.getClass().getName());
    }

    public static String getShortClassName(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return ClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        if (StringUtils.isEmpty(className)) {
            throw new IllegalArgumentException("The class name must not be empty");
        }
        char[] chars = className.toCharArray();
        int lastDot = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '.') {
                lastDot = i + 1;
            } else if (chars[i] == '$') {
                chars[i] = 46;
            }
            ++i;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }

    public static String getPackageName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return ClassUtils.getPackageName(cls.getName());
    }

    public static String getPackageName(String className) {
        if (StringUtils.isEmpty(className)) {
            throw new IllegalArgumentException("The class name must not be empty");
        }
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return className.substring(0, i);
    }

    public static List getAllSuperclasses(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        ArrayList classes = new ArrayList();
        Class superclass = cls.getSuperclass();
        while (superclass != null) {
            classes.add(superclass);
            superclass = superclass.getSuperclass();
        }
        return classes;
    }

    public static List getAllInterfaces(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        ArrayList<Class> list = new ArrayList<Class>();
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                List superInterfaces = ClassUtils.getAllInterfaces(interfaces[i]);
                Iterator it = superInterfaces.iterator();
                while (it.hasNext()) {
                    Class intface = (Class)it.next();
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
                ++i;
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    public static List convertClassNamesToClasses(List classNames) {
        if (classNames == null) {
            throw new IllegalArgumentException("The class names must not be null");
        }
        ArrayList classes = new ArrayList(classNames.size());
        Iterator it = classNames.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception ex) {
                classes.add(null);
            }
        }
        return classes;
    }

    public static List convertClassesToClassNames(List classes) {
        if (classes == null) {
            throw new IllegalArgumentException("The classes list must not be null");
        }
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class cls = (Class)it.next();
            if (cls == null) {
                classNames.add(null);
                continue;
            }
            classNames.add(cls.getName());
        }
        return classNames;
    }

    public static boolean isAssignable(Class[] classArray, Class[] toClassArray) {
        if (!ArrayUtils.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        int i = 0;
        while (i < classArray.length) {
            if (!ClassUtils.isAssignable(classArray[i], toClassArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAssignable(Class cls, Class toClass) {
        if (toClass == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static boolean isInnerClass(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return cls.getName().indexOf(36) >= 0;
    }
}

