/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.importexport.model.Job;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListJobsResult
implements Serializable {
    private ListWithAutoConstructFlag<Job> jobs;
    private Boolean isTruncated;

    public List<Job> getJobs() {
        if (this.jobs == null) {
            this.jobs = new ListWithAutoConstructFlag();
            this.jobs.setAutoConstruct(true);
        }
        return this.jobs;
    }

    public void setJobs(Collection<Job> jobs) {
        if (jobs == null) {
            this.jobs = null;
            return;
        }
        ListWithAutoConstructFlag jobsCopy = new ListWithAutoConstructFlag(jobs.size());
        jobsCopy.addAll(jobs);
        this.jobs = jobsCopy;
    }

    public ListJobsResult withJobs(Job ... jobs) {
        if (this.getJobs() == null) {
            this.setJobs(new ArrayList<Job>(jobs.length));
        }
        for (Job value : jobs) {
            this.getJobs().add(value);
        }
        return this;
    }

    public ListJobsResult withJobs(Collection<Job> jobs) {
        if (jobs == null) {
            this.jobs = null;
        } else {
            ListWithAutoConstructFlag jobsCopy = new ListWithAutoConstructFlag(jobs.size());
            jobsCopy.addAll(jobs);
            this.jobs = jobsCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListJobsResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobs() != null) {
            sb.append("Jobs: " + this.getJobs() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobs() == null ? 0 : this.getJobs().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResult)) {
            return false;
        }
        ListJobsResult other = (ListJobsResult)obj;
        if (other.getJobs() == null ^ this.getJobs() == null) {
            return false;
        }
        if (other.getJobs() != null && !other.getJobs().equals(this.getJobs())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        return other.isTruncated() == null || other.isTruncated().equals(this.isTruncated());
    }
}

