/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class ARecordTest
extends TestCase {
    Name m_an;
    Name m_rn;
    InetAddress m_addr;
    String m_addr_string;
    byte[] m_addr_bytes;
    long m_ttl;

    protected void setUp() throws TextParseException, UnknownHostException {
        this.m_an = Name.fromString("My.Absolute.Name.");
        this.m_rn = Name.fromString("My.Relative.Name");
        this.m_addr_string = "193.160.232.5";
        this.m_addr = InetAddress.getByName(this.m_addr_string);
        this.m_addr_bytes = this.m_addr.getAddress();
        this.m_ttl = 79225L;
    }

    public void test_ctor_0arg() throws UnknownHostException {
        ARecord ar = new ARecord();
        ARecordTest.assertNull((Object)ar.getName());
        ARecordTest.assertEquals((int)0, (int)ar.getType());
        ARecordTest.assertEquals((int)0, (int)ar.getDClass());
        ARecordTest.assertEquals((long)0L, (long)ar.getTTL());
        ARecordTest.assertEquals((Object)InetAddress.getByName("0.0.0.0"), (Object)ar.getAddress());
    }

    public void test_getObject() {
        ARecord ar = new ARecord();
        Record r = ar.getObject();
        ARecordTest.assertTrue((boolean)(r instanceof ARecord));
    }

    public void test_ctor_4arg() {
        ARecord ar = new ARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        ARecordTest.assertEquals((Object)this.m_an, (Object)ar.getName());
        ARecordTest.assertEquals((int)1, (int)ar.getType());
        ARecordTest.assertEquals((int)1, (int)ar.getDClass());
        ARecordTest.assertEquals((long)this.m_ttl, (long)ar.getTTL());
        ARecordTest.assertEquals((Object)this.m_addr, (Object)ar.getAddress());
        try {
            new ARecord(this.m_rn, 1, this.m_ttl, this.m_addr);
            ARecordTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new ARecord(this.m_an, 1, this.m_ttl, InetAddress.getByName("2001:0db8:85a3:08d3:1319:8a2e:0370:7334"));
            ARecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (UnknownHostException e) {
            ARecordTest.fail((String)e.getMessage());
        }
    }

    public void test_rrFromWire() throws IOException {
        DNSInput di = new DNSInput(this.m_addr_bytes);
        ARecord ar = new ARecord();
        ar.rrFromWire(di);
        ARecordTest.assertEquals((Object)this.m_addr, (Object)ar.getAddress());
    }

    public void test_rdataFromString() throws IOException {
        Tokenizer t = new Tokenizer(this.m_addr_string);
        ARecord ar = new ARecord();
        ar.rdataFromString(t, null);
        ARecordTest.assertEquals((Object)this.m_addr, (Object)ar.getAddress());
        t = new Tokenizer("193.160.232");
        ar = new ARecord();
        try {
            ar.rdataFromString(t, null);
            ARecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_rrToString() {
        ARecord ar = new ARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        ARecordTest.assertEquals((String)this.m_addr_string, (String)ar.rrToString());
    }

    public void test_rrToWire() {
        ARecord ar = new ARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        DNSOutput dout = new DNSOutput();
        ar.rrToWire(dout, null, true);
        ARecordTest.assertTrue((boolean)Arrays.equals(this.m_addr_bytes, dout.toByteArray()));
        dout = new DNSOutput();
        ar.rrToWire(dout, null, false);
        ARecordTest.assertTrue((boolean)Arrays.equals(this.m_addr_bytes, dout.toByteArray()));
    }
}

