'use strict';

module.exports = function (grunt) {

    grunt.config.merge({ copy: {
        build_thirdparty: {
            files: [
                {
                    src: ['bootstrap.min.js'],
                    expand: true,
                    cwd: 'bower_components/bootstrap/dist/js',
                    dest: 'build/<%= baseDir %>'
                }, {
                    src: ['jquery.min.js'],
                    expand: true,
                    cwd: 'bower_components/jquery/dist',
                    dest: 'build/<%= baseDir %>'
                }
           ]
        },
        build_help: {
            files: [
                {
                    src: ['**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'html',
                    dest: 'build/<%= baseDir %>'
                }
            ]
        },
        dist_help: {
            files: [
                {
                    src: ['**/*', '!l10n/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'build/<%= baseDir %>',
                    dest: 'dist/appsuite/<%= baseDir %>'
                }
            ]
        },
        local_install_static: {
            files: [
                {
                    src: ['**/*', '!appsuite/<%= baseDir %>/l10n/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'dist/',
                    dest: grunt.option('htdoc')
                }
            ]
        }
    }});

    // add dist l10n copy tasks

    grunt.file.expand({
        cwd: 'html/l10n',
        filter: 'isDirectory'
    }, '*').forEach(function (Lang) {
        var lang = Lang.toLowerCase().replace(/_/g, '-'),
            config = {};

        config['dist_help_' + Lang] = {
            files: [
                {
                    src: ['l10n/' + Lang + '/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'build/<%= baseDir %>',
                    dest: 'dist/appsuite/<%= baseDir %>'
                }
            ]
        };
        config['local_install_' + Lang] = {
            files: [
                {
                    src: ['appsuite/<%= baseDir %>/l10n/' + Lang + '/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'dist/',
                    dest: grunt.option('htdoc')
                }
            ]
        };

        grunt.config.merge({ 'copy': config });
        grunt.registerTask('install:' + Lang, 'install language directory into a custom location', function () {
            if (!grunt.option('htdoc')) {
                grunt.fail.fatal('Need --htdoc option to be set');
            }
            grunt.log.writeln('Installing into:', grunt.option('htdoc'));
            grunt.task.run('copy:local_install_' + Lang);
        });
    });
    grunt.loadNpmTasks('grunt-contrib-copy');
};
