/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import com.openexchange.guard.keymanagement.commons.RecipKey;
import com.openexchange.guard.milter.service.MilterMail;

/**
 * {@link GuardMilterMail}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class GuardMilterMail implements MilterMail {

    private ArrayList<String> rcpts;

    private ArrayList <RecipKey> keys;

    private HashMap<String, String> headers;

    private byte[] body;

    private boolean willHandle = true;

    public GuardMilterMail () {
        this.rcpts = new ArrayList<String>();
        this.headers = new HashMap<String, String>();
        this.keys = new ArrayList<RecipKey>();
        this.body = null;
        this.willHandle = true;
    }

    @Override
    public void addRcpt (String rcpt) {
        rcpts.add(rcpt);
    }

    @Override
    public void addHeader (String header, String value) {
        this.headers.put(header, value);
    }

    @Override
    public void addBody (byte[] body) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.body != null) out.write(this.body);  // Concat to existing body data
        out.write(body);
        this.body = out.toByteArray();
    }

    @Override
    public ArrayList<String> getRcpts () {
        return rcpts;
    }

    @Override
    public String getHeader (String header) {
        return this.headers.get(header);
    }

    @Override
    public String getBody () {
        return this.body == null ? null : new String(this.body, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBodyBytes () {
        return this.body;
    }

    @Override
    public boolean willHandle() {
        return this.willHandle;
    }

    @Override
    public void addRecipientKey(RecipKey key) {
        keys.add(key);
    }

    /*
     * Get list of recipient Keys
     */
    @Override
    public ArrayList<RecipKey> getKeys() {
        return keys;
    }

    @Override
    public void setHandle(boolean toHandle) {
        this.willHandle = toHandle;

    }

}
