/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import com.openexchange.guard.keymanagement.commons.RecipKey;

/**
 * {@link MilterMail}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public interface MilterMail {

    public void addRcpt (String rcpt);

    public void addHeader (String header, String value);

    public void addBody (byte[] body) throws IOException;

    public ArrayList<String> getRcpts ();

    public String getHeader (String header);

    public String getBody ();

    public boolean willHandle();

    public void setHandle(boolean toHandle);

    public void addRecipientKey (RecipKey key);

    public ArrayList<RecipKey> getKeys();

    public byte[] getBodyBytes();
}
