/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.guard.guestreset;

import com.google.gson.JsonObject;
import com.openexchange.exception.OXException;

/**
 * {@link GuestResetService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.6.0
 */
public interface GuestResetService {

    /**
     * Sends a reset email to the user
     * @param email The email of the guest user
     * @param force  Force the reset even if a password recovery exists
     * @throws OXException
     */
    public void reset(String email, String host, boolean force, String ip) throws OXException;

    /**
     * Performs a guest reset for email
     * @param email
     * @param verification  Verification code from the reset email
     * @throws OXException
     */
    public void doReset(JsonObject data, String ip) throws OXException;


}
