/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define([
    'oxguard/settings/defaults',
    'spec/shared/capabilities'
], function (defaults, caputil) {
    'use strict';

    var capabilities = caputil.preset('common').init(['oxguard/settings/defaults'], [defaults]);

    describe('Guard settings', function () {
        describe('cryptoProvider defaults', function () {
            it('with cap=guard,-mailvelope,-forceMailvelope (guard only scenario)', function () {
                return capabilities
                    .enable(['guard'])
                    .then(function () {
                        return capabilities.disable(['mailvelope', 'forceMailvelope']);
                    })
                    .then(function () {
                        expect(defaults.cryptoProvider).to.equal('guard');
                    });
            });

            it('with cap=-guard,mailvelope,-forceMailvelope (mailvelope only scenario)', function () {
                return capabilities
                    .enable(['mailvelope'])
                    .then(function () {
                        return capabilities.disable(['guard', 'forceMailvelope']);
                    })
                    .then(function () {
                        expect(defaults.cryptoProvider).to.equal('mailvelope');
                    });
            });

            it('with cap=guard,mailvelope,forceMailvelope (admin enforces mailvelope usage scenario)', function () {
                return capabilities
                    .enable(['guard', 'mailvelope', 'forceMailvelope'])
                    .then(function () {
                        return capabilities.disable([]);
                    })
                    .then(function () {
                        expect(defaults.cryptoProvider).to.equal('mailvelope');
                    });
            });

            it('with cap=-guard,-mailvelope,-forceMailvelope (everything disabled scenario)', function () {
                return capabilities
                    .enable([])
                    .then(function () {
                        return capabilities.disable(['guard', 'mailvelope', 'forceMailvelope']);
                    })
                    .then(function () {
                        expect(defaults.cryptoProvider).not.to.be.defined;
                    });
            });

            it('with cap=guard,mailvelope,-forceMailvelope (user must choose scenario)', function () {
                return capabilities
                    .enable(['guard', 'mailvelope'])
                    .then(function () {
                        return capabilities.disable(['forceMailvelope']);
                    })
                    .then(function () {
                        expect(defaults.cryptoProvider).not.to.be.defined;
                    });
            });
        });
    });
});
