/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define([
    'oxguard/mail_lock/toggle-encryption'
], function (ToggleEncryption) {
    describe('Toggle Encryption Button', function () {
        describe('View', function () {
            //var deviceStub;
            beforeEach(function () {
                //deviceStub = sinon.stub(_, 'device').withArgs('small').returns(false);
                window.oxguarddata.settings.oxguard = true;
            });
            afterEach(function () {
                _.device.restore();
            });

            it('should render an icon', function () {
                var v = new ToggleEncryption.View({
                    model: new Backbone.Model()
                });
                v.render();
                expect(v.$('i.fa').length, 'one font-awesome icon found').to.equal(1);
                expect(v.$('.encrypted').length, 'no encrypted class found').to.equal(0);
            });

            it('should add encryption class if encrypted', function () {
                var v = new ToggleEncryption.View({
                    model: new Backbone.Model({
                        encrypt: true
                    })
                });
                v.render();
                expect(v.$('i.fa').length, 'one font-awesome icon found').to.equal(1);
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(1);
            });

            it('should toggle encryption class if model changes', function () {
                var v = new ToggleEncryption.View({
                    model: new Backbone.Model()
                });
                v.render();
                expect(v.$('i.fa').length, 'one font-awesome icon found').to.equal(1);
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(0);
                v.model.set('encrypt', true);
                expect(v.$('i.fa').length, 'one font-awesome icon found').to.equal(1);
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(1);
            });

            it('should toggle encryption class on click', function () {
                var v = new ToggleEncryption.View({
                    model: new Backbone.Model()
                });
                v.render();
                expect(v.$('i.fa').length, 'one font-awesome icon found').to.equal(1);
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(0);
                v.$('i.fa').click();
                expect(v.$('i.fa').length, 'one font-awesome icon found').to.equal(1);
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(1);
            });

            it('should not toggle encryption if forceEncryption option is set true', function () {
                var v = new ToggleEncryption.View({
                    model: new Backbone.Model()
                });

                expect(v.model.get('encrypt')).not.to.be.defined;
                v.forceEncryption();
                v.render();

                expect(v.model.get('encrypt')).to.be.true;
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(1);
                v.$('i.fa').click();
                expect(v.model.get('encrypt')).to.be.true;
                expect(v.$('.encrypted').length, 'encrypted class found').to.equal(1);
            });
        });
    });
});
