/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Bad Passwords');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Bad password tests decrypting email', async function (I, users) {

    const count = 4;  // number of emails
    const o = {
        user: users[0]
    };
    const user = o.user, userdata = o.user.userdata;

    I.login('app=io.ox/mail', o);

    await I.verifyUserSetup(userdata);

    await I.haveMail({
        attachments: [{
            content: 'Test content ',
            content_type: 'text/html',
            disp: 'inline'
        }],
        from: [[user.get('display_name'), user.get('primaryEmail')]],
        sendtype: 0,
        subject: 'Test subject ',
        to: [[user.get('display_name'), user.get('primaryEmail')]],
        security: {
            encrypt: true,
            sign: false,
            type: 'pgp'
        }
    });

    I.waitForElement('#io-ox-refresh-icon .fa-spin');
    I.waitForDetached('#io-ox-refresh-icon .fa-spin');
    I.click('#io-ox-refresh-icon');
    
    I.waitForVisible('.list-item.unread');

    I.click('.list-item.unread');   // click email

    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', { password: 'failme' });
    I.click('.btn.oxguard_passbutton');

    I.waitForVisible('.io-ox-alert-error');
    I.see('Bad password', '.io-ox-alert-error');

});

Scenario('Bad password test file', async function (I, users) {

    const o = {
        user: users[0],
        cryptoAction: 'encrypt'
    };
    const userdata = o.user.userdata;

    I.login('app=io.ox/files', o);
    
    await I.verifyUserSetup(userdata);

    const infostoreFolderID = await I.grabDefaultFolder('infostore');
    let fileId = await I.haveFile(infostoreFolderID, 'e2e/testFiles/simpleText.txt', o);
    let id = fileId.folder_id + '.' + fileId.id;
    I.waitForElement('#io-ox-refresh-icon .fa-spin');
    I.waitForDetached('#io-ox-refresh-icon .fa-spin');
    I.click('#io-ox-refresh-icon');
    // Encrypt the file
    I.waitForVisible('.list-view li[data-cid="' + id + '"]');
    I.doubleClick('.list-view li[data-cid="' + id + '"]');

    I.auth({ password: 'failme' });

    I.waitForVisible('.io-ox-alert-error');
    I.see('Bad password', '.io-ox-alert-error');


});

Scenario('Lockout test', async function (I, users) {

    const count = 4;  // number of emails
    const o = {
        user: users[0]
    };
    const user = o.user, userdata = o.user.userdata;

    I.login('app=io.ox/mail', o);

    await I.verifyUserSetup(userdata);

    await I.haveMail({
        attachments: [{
            content: 'Test content ',
            content_type: 'text/html',
            disp: 'inline'
        }],
        from: [[user.get('display_name'), user.get('primaryEmail')]],
        sendtype: 0,
        subject: 'Test subject ',
        to: [[user.get('display_name'), user.get('primaryEmail')]],
        security: {
            encrypt: true,
            sign: false,
            type: 'pgp'
        }
    });

    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');
    I.waitForElement('#io-ox-refresh-icon .fa-spin');
    I.waitForDetached('#io-ox-refresh-icon .fa-spin');
    I.click('#io-ox-refresh-icon');

    I.waitForVisible('.list-item.unread');

    I.click('.list-item.unread');   // click email

    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', { password: 'failme' });
    I.click('.btn.oxguard_passbutton');

    I.waitForVisible('.io-ox-alert-error');
    I.see('Bad password', '.io-ox-alert-error');
    for (var i = 0; i < 6; i++) {
        I.click('.io-ox-alert-error .btn');
        I.wait(1);
        I.click('.btn.oxguard_passbutton');
        I.waitForVisible('.io-ox-alert-error');
    }

    I.see('Lockout', '.io-ox-alert-error');

});