/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Send Encrypted To OX User without Guard-Mail capability');

Before(async function (users) {
    await users.create();
    await users.create();  // Two users
});

After(async function (users, I) {
    await I.wipeUser(users).catch(e => console.log(e));;  // cleanup guest accounts
    await users.removeAll();
});

Scenario('Compose and email to ox user without guard-mail', async function (I, users) {

    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);
    await I.setupUser(o2);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    await o2.user.doesntHaveCapability('guard-mail');  // Testing for user without Guard-mail capability

    // Log in as User 0
    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Compose email to Guest
    I.sendEmail(userdata2, subject, data);

    I.wait(2);

    I.logout();

    // Login to retrieve guest invite email
    I.login('app=io.ox/mail', o2);
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Change temporary password
    I.changeTemporaryPassword(userdata2);

    // Verify decrypted
    I.verifyDecryptedMail(subject, data);

    I.waitForElement('.guardUpsell');   // Upsell should be present

    // test Guest reply
    I.click('Reply');

    I.waitForVisible('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata2);
    I.click('.btn[data-action="ok"]');

    I.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');
    I.waitForVisible('.window-blocker.io-ox-busy');
    I.waitForInvisible('.window-blocker.io-ox-busy');
    // Check unable to add recipients
    I.dontSeeElementInDOM('.recipient-actions');

    I.waitForElement('.io-ox-mail-compose-window button[aria-label="Save and close"]');
    I.click('.io-ox-mail-compose-window button[aria-label="Save and close"]');

});
