/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This sends a new email to recipient
 */

module.exports  = function (userdata, subject, data, attachment, options) {

       options = options || {};

       var optionsDropdown = locate({ css: '[data-extension-id="composetoolbar-menu"] a[aria-label="Options"]' }).as('Options dropdown');

       // Open compose
       this.wait(2);
       this.click('Compose');
       this.waitForVisible('.window-blocker.io-ox-busy');
       this.waitForInvisible('.window-blocker.io-ox-busy');
       this.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');

       if (options.smime) {
          this.click(optionsDropdown);
          this.waitForText('Use S/MIME', 10, '.dropdown.open .dropdown-menu');
          this.click('Use S/MIME', '.dropdown.open .dropdown-menu');
         }

       // Mark as secure unless specified as non-encrypted
       if (!options.unencrypted) {
          this.seeElement('.io-ox-mail-compose-window .toggle-encryption');
          this.click('.io-ox-mail-compose-window .toggle-encryption');
          if (!options.smime_only && !options.smime) {  // When using smime, no password prompt
               this.waitForVisible('#ogPassword');
               this.fillField('#ogPassword', userdata.password);
               this.click('.btn[data-action="ok"]');
          }
          this.waitForVisible('.fa.fa-2x.encrypted');
       }

       if (options.attachKey) {
          this.click(optionsDropdown);
          this.waitForText('Attach my public key', 10, '.dropdown.open .dropdown-menu');
          this.wait(1);
          this.click('Attach my public key', '.dropdown.open .dropdown-menu');
          this.waitForElement('.file[title="public.asc"]');
       }

       if (options.sign) {
        this.click(optionsDropdown);
        this.waitForText('Sign email', 10, '.dropdown.open .dropdown-menu');
        this.click('Sign email', '.dropdown.open .dropdown-menu');
       }

       // Verify HTML
       this.click(optionsDropdown);
       this.click('HTML');
       this.waitForVisible('.io-ox-mail-compose .editor .mce-panel');


       if (options.inline) {
        this.wait(1);
        this.click('.security-options a');
        this.waitForVisible('.dropdown.open a[data-name="pgpInline"]');
        this.wait(1);
        this.click('Inline');
        this.waitForVisible('.btn[data-action="okx"]');
        this.click('.btn[data-action="okx"]');
        this.waitForInvisible('.modal-backdrop');
       }

       // Insert test data
       this.fillField('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', userdata.email1);
       this.fillField('.io-ox-mail-compose [name="subject"]', subject);
       var I = this;

       if (options.inline) {  // Inline plaintext only
            I.fillField('.plain-text', data);
       } else {
            within({ frame: '.io-ox-mail-compose-window .editor iframe' }, async () => {
              I.fillField('.mce-content-body', data);
            });
       }

       // Attachments if any
       if (attachment) {
            this.attachFile('.composetoolbar input[type="file"]', attachment);
            this.wait(2);
       }

       // Verify key is next to recipient names
       if (!options.unencrypted) {
            this.waitForVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key');
       }

       if (!options.dontsend) {
          this.click('Send');

          if (options.sign) {
              this.waitForVisible('#ogPassword');
              this.fillField('#ogPassword', userdata.password);
              this.click('.btn[data-action="ok"]');
          }
          this.waitForVisible('.io-ox-mail-window .leftside');
          I.waitForInvisible('.mail-progress', attachment ? 60 : 10);
       }


};
