/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2022 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/smime/uploader', [
    'io.ox/core/yell',
    'gettext!oxguard'], function (yell, gt) {

    // Uploads SMIME key
    function upload(files, oldPass, guard) {
        var deferred = $.Deferred();
        var formData = new FormData();
        for (var l = 0; l < files.length; l++) {
            if (!validFileType(files[l])) {
                deferred.reject();
                return deferred;
            }
            if (files[l] !== undefined) { formData.append('key' + l, files[l]); }
        }
        formData.append('password', oldPass);
        formData.append('newPassword', guard);

        var url = ox.apiRoot + '/oxguard/certificates?action=upload&respondWithJSON=true&session=' + ox.session;
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            processData: false, // tell jQuery not to process the data
            contentType: false, // tell jQuery not to set contentType
            success: function (data) {
                if (data && data.error) {
                    yell('error', data.error);
                    deferred.reject(data.error);
                }
                deferred.resolve(data.data);
            }
        });
        return deferred;
    }

    function validFileType(file) {
        if (!/^.*\.(p12|pfx)$/i.test(file.name)) {
            console.error('bad file type ' + file.name);
            //#.  User attempted to upload an unsupported file type.  Expecting a type of file with standard name PKCS#12.  Only files with .p12 and .pfx suffixes allowed
            yell('error', gt('Only S/MIME file types of .p12 and .pfx supported.  Expects PKCS#12 file type'));
            return false;
        }
        return true;
    }

    return {
        upload: upload
    };
});
