/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/settings/views/userKeysView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/settings/userKeys',
    'gettext!oxguard'
    //'settings!oxguard'
], function (ext, ModalDialog, userKeys, gt) {

    'use strict';

    var POINT = 'oxguard/settings/userkeys',
        INDEX = 0;

    function openModalDialog() {

        return new ModalDialog({
            async: true,
            point: POINT,
            title: gt('Your Keys'),
            id: 'userKeyList',
            width: 640
        })
        .extend({
            body: function () {
                this.$el.addClass('maxheight');
            }
        })
        .addCloseButton()
        .open();
    }

    ext.point(POINT).extend(
        // Draw Div with list keys
        {
            index: INDEX += 100,
            id: 'switch',
            render: function () {
                var div = $('<div>');
                this.$body.append(
                    div.append(userKeys.userKeys())
                );
            }
        }
    );

    return {
        open: openModalDialog
    };

});
