/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/revokePrivateView', [
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/api/keys',
    'oxguard/core/passwordView',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ModalDialog, util, yell, keysAPI, PasswordView, core, gt) {

    'use strict';

    function openModalDialog(keyid) {

        return new ModalDialog({
            async: true,
            point: 'oxguard/settings/revokePrivate',
            title: gt('Revoke Private Key'),
            width: 640,
            model: new Backbone.Model({ 'revokereason': 'NO_REASON' }),
            enter: 'cancel',
            focus: '#revokepass'
        })
        .extend({
            'warning': function () {
                this.$body.append(
                    $('<p class="bg-warning bg-padding">').append(
                        gt('This will advise people not to use this key. You can still use the key to decode existing items.')
                    )
                );
            },
            'password': function () {

                this.$body.append(
                    $('<label for="revokepass">').text(
                        gt('Your %s password', ox.guard.getName())
                    ),
                    new PasswordView.view({ 'id': 'revokepass' }).getProtected()
                );
            },
            'revoke': function () {
                this.$body.append(
                    util.compactSelect('revokereason', gt('Revocation reason'), this.model, [
                        { label: gt('No Reason'), value: 'NO_REASON' },
                        { label: gt('Key superseded'), value: 'KEY_SUPERSEDED' },
                        { label: gt('Key compromised'), value: 'KEY_COMPROMISED' },
                        { label: gt('Key retired'), value: 'KEY_RETIRED' },
                        { label: gt('User no longer valid'), value: 'USER_NO_LONGER_VALID' }
                    ])
                );
            }

        })
        .addButton({ label: gt('Revoke'), action: 'revoke', className: 'btn-default' })
        .on('revoke', function () {
            var dialog = this,
                password = $('#revokepass').val(),
                reason = this.model.get('revokereason'),
                invalid = password.length <= 1;

            if (invalid) {
                this.idle();
                return yell('info', gt('Please enter your password'));
            }

            core.metrics('settings', 'revoke-private-key');
            return keysAPI.revoke(keyid, { password: password, reason: reason }).then(function () {
                dialog.close();
            }, function () {
                dialog.idle();
            });
        })
        .addCloseButton()
        .open();
    }

    return {
        open: openModalDialog
    };

});
