/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/publicKeysView', [
    'io.ox/backbone/views/modal',
    'oxguard/pgp/keyDetails',
    'gettext!oxguard'
], function (ModalDialog, pubkeys, gt) {

    'use strict';

    function openModalDialog(options) {

        return new ModalDialog(_.extend({
            async: false,
            point: 'oxguard/settings/pubkeys',
            title: gt('Public Keys'),
            id: 'pkeyList',
            width: '75%'
        }, options))
        .extend({
            'list-public': function () {
                this.$el.addClass('maxheight');
                this.$body.append(
                    pubkeys.listPublic({
                        id: 'settings'
                    })
                );
            }
        })
        .addCloseButton()
        .open();
    }

    return {
        open: openModalDialog
    };

});
